/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.excel.imp;

import cn.sylinx.excel.imp.DataPersistenceSupport;
import cn.sylinx.excel.imp.PersistenceRowHandler;
import cn.sylinx.excel.imp.RowData;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class DefaultRowHandler
implements PersistenceRowHandler {
    private int commitRowCount = 2000;
    private DataPersistenceSupport dataPersistenceSupport;
    private int sheetIndex = -1;
    private List<RowData> rowDataList = new ArrayList<RowData>();

    public void handle(int sheetIndex, long rowIndex, List<Object> rowCells) {
        if (this.isSheetSkip(sheetIndex)) {
            this.flushAll();
        }
        if (this.isRowReachThreshold()) {
            this.flushAll();
        }
        this.sheetIndex = sheetIndex;
        this.rowDataList.add(RowData.create(sheetIndex, rowIndex, rowCells));
    }

    public int getCommitRowCount() {
        return this.commitRowCount;
    }

    public void setCommitRowCount(int commitRowCount) {
        this.commitRowCount = commitRowCount;
    }

    public DataPersistenceSupport getDataPersistenceSupport() {
        return this.dataPersistenceSupport;
    }

    public void setDataPersistenceSupport(DataPersistenceSupport dataPersistenceSupport) {
        this.dataPersistenceSupport = dataPersistenceSupport;
    }

    @Override
    public void flushAll() {
        Objects.requireNonNull(this.dataPersistenceSupport, "dataPersistenceSupport should not be null");
        try {
            this.dataPersistenceSupport.persist(this.rowDataList);
        }
        finally {
            this.reset();
        }
    }

    private boolean isRowReachThreshold() {
        return this.rowDataList.size() >= this.commitRowCount;
    }

    private boolean isSheetSkip(int currentSheetIndex) {
        return this.sheetIndex > -1 && currentSheetIndex > this.sheetIndex;
    }

    private void reset() {
        this.rowDataList.clear();
        this.sheetIndex = -1;
    }
}

