/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.horm.pool;

import cn.sylinx.horm.pool.AbstractDataSourceCreator;
import cn.sylinx.horm.pool.BoneCPDataSourceCreator;
import cn.sylinx.horm.pool.C3p0DataSourceCreator;
import cn.sylinx.horm.pool.DataSourceSelector;
import cn.sylinx.horm.pool.Dbcp2DataSourceCreator;
import cn.sylinx.horm.pool.DbcpDataSourceCreator;
import cn.sylinx.horm.pool.DruidDataSourceCreator;
import cn.sylinx.horm.pool.HikariDataSourceCreator;
import cn.sylinx.horm.pool.PoolType;
import cn.sylinx.horm.pool.TomcatJdbcDataSourceCreator;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;

public class DefaultDataSourceSelector
implements DataSourceSelector {
    private Map<String, Object> dsMap = new HashMap<String, Object>();
    private Map<String, Object> extConfig;

    public DefaultDataSourceSelector(Map<String, Object> dsMap, Map<String, Object> extConfig) {
        this.dsMap.putAll(dsMap);
        this.extConfig = extConfig;
        this.combined();
    }

    private void combined() {
        this.dsMap.put("config", this.extConfig);
    }

    @Override
    public DataSource select(PoolType pt) {
        if (pt == null) {
            return null;
        }
        AbstractDataSourceCreator creator = null;
        switch (pt) {
            case Druid: {
                creator = new DruidDataSourceCreator();
                break;
            }
            case TomcatJdbc: {
                creator = new TomcatJdbcDataSourceCreator();
                break;
            }
            case BoneCP: {
                creator = new BoneCPDataSourceCreator();
                break;
            }
            case C3P0: {
                creator = new C3p0DataSourceCreator();
                break;
            }
            case Dbcp2: {
                creator = new Dbcp2DataSourceCreator();
                break;
            }
            case Dbcp: {
                creator = new DbcpDataSourceCreator();
                break;
            }
            case Hikari: {
                creator = new HikariDataSourceCreator();
                break;
            }
        }
        if (creator != null) {
            return creator.create(this.dsMap);
        }
        return null;
    }
}

