/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.horm.proxy.mapper.registrar;

import cn.sylinx.horm.proxy.ProxyObjectRegistry;
import cn.sylinx.horm.proxy.mapper.parse.MapperParser;
import cn.sylinx.horm.proxy.mapper.parse.Namespace;
import cn.sylinx.horm.proxy.mapper.parse.NamespaceContainer;
import cn.sylinx.horm.proxy.mapper.registrar.MapperRegistrar;
import cn.sylinx.horm.resource.io.MapperXmlScanner;
import cn.sylinx.horm.resource.io.Resources;
import cn.sylinx.horm.util.GLog;
import cn.sylinx.horm.util.StrKit;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;

public class DefaultMapperRegistrar
implements MapperRegistrar {
    static final MapperRegistrar DEFAULT_MR = new DefaultMapperRegistrar();

    @Override
    public void register(String mapperScanPackage, String matchedPostfix) {
        if (StrKit.isBlank(mapperScanPackage)) {
            GLog.warn("horm.config.mapper-scan-package\u6ca1\u6709\u914d\u7f6e\uff0c\u8fd9\u5c06\u5bfc\u81f4\u82b1\u8d39\u66f4\u591a\u65f6\u95f4\u626b\u63cf\u6574\u4e2a\u9879\u76ee", new Object[0]);
        }
        String pkgInfo = StrKit.isBlank(mapperScanPackage) ? "\u6574\u4e2a\u9879\u76ee" : mapperScanPackage;
        GLog.info("\u626b\u63cf\u5305:{}, \u5bfb\u627eMapper\u5bf9\u8c61", pkgInfo);
        int count = 0;
        MapperXmlScanner xml = new MapperXmlScanner(mapperScanPackage, matchedPostfix);
        Set<Object> xmlSets = xml.scan(true);
        for (Object xmlObject : xmlSets) {
            InputStream xmlIs = null;
            try {
                xmlIs = Resources.getResourceAsStream(xmlObject.toString());
            }
            catch (IOException e) {
                GLog.error("get mapper resource[" + xmlObject + "] error:" + e.getMessage(), e);
            }
            if (xmlIs == null) continue;
            Namespace ns = MapperParser.create().parse(xmlIs);
            if (ns == null) {
                GLog.error("get mapper resource[" + xmlObject + "] error", new Object[0]);
            }
            NamespaceContainer.register(ns);
            ProxyObjectRegistry.INSTANCE.register(ns.getMapperClass());
            ++count;
        }
        GLog.info("\u626b\u63cf\u5305:{}\uff0c\u5bfb\u627eMapper\u5bf9\u8c61\u5b8c\u6bd5\uff0c\u603b\u8ba1:{}", pkgInfo, count);
    }
}

