/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.horm.resource.parse;

import cn.sylinx.horm.config.OrmConfigHolder;
import cn.sylinx.horm.dialect.DbType;
import cn.sylinx.horm.exception.HORMException;
import cn.sylinx.horm.resource.ClasspathSqlResource;
import cn.sylinx.horm.resource.ClasspathSqlResourceManager;
import cn.sylinx.horm.resource.StatementHandler;
import cn.sylinx.horm.resource.parse.GenericTokenParser;
import cn.sylinx.horm.resource.parse.TokenHandler;
import cn.sylinx.horm.util.GLog;
import cn.sylinx.horm.util.Pair;
import cn.sylinx.horm.util.StrKit;
import java.util.HashMap;
import java.util.Map;

public class SqlParser {
    static final String SQL_POSTFIX = ".sql";
    static String KW_INCLUDE_SQL_BEGIN = "#INC[";
    static String KW_INCLUDE_SQL_END = "]";
    static Map<String, String> incSqlMap = new HashMap<String, String>();
    private DbType dbtype;
    private String sqlPostfix = ".sql";

    public SqlParser() {
        this(null);
    }

    public SqlParser(DbType dbtype) {
        this(SQL_POSTFIX, dbtype);
    }

    public SqlParser(String sqlPostfix, DbType dbtype) {
        this.sqlPostfix = sqlPostfix;
        this.dbtype = dbtype;
    }

    public DbType getDbtype() {
        return this.dbtype;
    }

    public void setDbtype(DbType dbtype) {
        this.dbtype = dbtype;
    }

    public String getSqlPostfix() {
        return this.sqlPostfix;
    }

    public void setSqlPostfix(String sqlPostfix) {
        this.sqlPostfix = sqlPostfix;
    }

    public Pair parseSql(ClasspathSqlResource sqlResource, Map<String, Object> params) {
        String statement = this.getRealStatment(sqlResource.getSqlpath());
        return this.parseSql(statement, params, sqlResource.isFormat(), sqlResource.getStatementHandler());
    }

    protected String getStatement(String sqlpath) {
        String truelySqlPath = this.parseTruelySqlpath(sqlpath);
        String statement = ClasspathSqlResourceManager.getStatement(truelySqlPath);
        if (StrKit.isBlank(statement)) {
            throw new HORMException("SQL\u8bed\u53e5\u4e3a\u7a7a, \u8d44\u6e90:" + truelySqlPath);
        }
        return statement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getRealStatment(String sqlpath) {
        String cachedSqlContent;
        String sqlContent = this.getStatement(sqlpath);
        int incIndex = sqlContent.indexOf(KW_INCLUDE_SQL_BEGIN);
        if (incIndex < 0) {
            return sqlContent;
        }
        if (OrmConfigHolder.isDebug()) {
            return this.parseIncludeSqlContent(sqlContent);
        }
        String cacheKey = sqlpath;
        if (this.dbtype != null) {
            cacheKey = cacheKey + "|" + this.dbtype.getValue();
        }
        if ((cachedSqlContent = incSqlMap.get(cacheKey)) != null) {
            return cachedSqlContent;
        }
        String string = cacheKey.intern();
        synchronized (string) {
            cachedSqlContent = this.parseIncludeSqlContent(sqlContent);
            incSqlMap.put(cacheKey, cachedSqlContent);
        }
        return cachedSqlContent;
    }

    protected String parseIncludeSqlContent(String sqlContent) {
        int incIndex = sqlContent.indexOf(KW_INCLUDE_SQL_BEGIN);
        if (incIndex < 0) {
            return sqlContent;
        }
        String incIndexLeft = sqlContent.substring(0, incIndex);
        String incIndexRight = sqlContent.substring(incIndex + KW_INCLUDE_SQL_BEGIN.length());
        int incIndex1 = incIndexRight.indexOf(KW_INCLUDE_SQL_END);
        if (incIndex1 < 0) {
            throw new HORMException("INC\u8bed\u6cd5\u9519\u8bef");
        }
        String incSqlPath = incIndexRight.substring(0, incIndex1);
        if (StrKit.isBlank(incSqlPath)) {
            throw new HORMException("INC\u8bed\u6cd5\u9519\u8bef\uff0c\u4e22\u5931SQL\u8d44\u6e90\u8def\u5f84");
        }
        String incIndex1Right = incIndexRight.substring(incIndex1 + KW_INCLUDE_SQL_END.length());
        return incIndexLeft + this.getRealStatment(incSqlPath.trim()) + this.parseIncludeSqlContent(incIndex1Right);
    }

    protected String getRealSqlPostfix() {
        return "_" + this.dbtype.getValue() + this.sqlPostfix;
    }

    protected String parseTruelySqlpath(String sqlpath) {
        if (this.dbtype == null) {
            return sqlpath;
        }
        String dbtypePostfix = this.getRealSqlPostfix();
        boolean endsWithDbtypePostfix = sqlpath.endsWith(dbtypePostfix);
        if (endsWithDbtypePostfix) {
            return sqlpath;
        }
        int index = sqlpath.lastIndexOf(this.sqlPostfix);
        if (index < 1) {
            throw new HORMException("invalid sql resource file");
        }
        return sqlpath.substring(0, index) + dbtypePostfix;
    }

    public Pair parseSql(String statement, Map<String, Object> params, StatementHandler sqlHandler) {
        return this.parseSql(statement, params, true, sqlHandler);
    }

    public Pair parseSql(String statement, Map<String, Object> params) {
        return this.parseSql(statement, params, null);
    }

    public Pair parseSql(String statement, Map<String, Object> params, boolean format, StatementHandler sqlHandler) {
        TokenHandler handler = this.createWithParameterMap(params);
        GenericTokenParser gt = new GenericTokenParser(handler);
        Pair tp = gt.parse(statement, format);
        if (sqlHandler != null) {
            String statementReplace = sqlHandler.handle(tp.getObject(0, String.class));
            GLog.debug("changed sql: " + statementReplace, new Object[0]);
            return Pair.apply((Object)statementReplace, tp.get(1));
        }
        return tp;
    }

    private TokenHandler createWithParameterMap(Map<String, Object> params) {
        TokenHandler handler = TokenHandler.create();
        handler.setParameterMap(params);
        return handler;
    }
}

