/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.horm.type.handler;

import cn.sylinx.horm.type.JdbcType;
import cn.sylinx.horm.type.handler.BaseTypeHandler;
import java.io.Reader;
import java.io.StringReader;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class ClobTypeHandler
extends BaseTypeHandler<String> {
    @Override
    protected JdbcType getJdbcTypeMapper() {
        return JdbcType.CLOB;
    }

    @Override
    public void setNonNullParameter(PreparedStatement ps, int i, String parameter) throws SQLException {
        StringReader reader = new StringReader(parameter);
        ps.setCharacterStream(i, (Reader)reader, parameter.length());
    }

    @Override
    public String getNullableResult(ResultSet rs, String columnName) throws SQLException {
        String value = "";
        Clob clob = rs.getClob(columnName);
        if (clob != null) {
            int size = (int)clob.length();
            value = clob.getSubString(1L, size);
        }
        return value;
    }

    @Override
    public String getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        String value = "";
        Clob clob = rs.getClob(columnIndex);
        if (clob != null) {
            int size = (int)clob.length();
            value = clob.getSubString(1L, size);
        }
        return value;
    }

    @Override
    public String getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        String value = "";
        Clob clob = cs.getClob(columnIndex);
        if (clob != null) {
            int size = (int)clob.length();
            value = clob.getSubString(1L, size);
        }
        return value;
    }
}

