/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.horm.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class RelaxedPropertyResolver {
    private Properties properties;
    private String prefix;
    private Map<String, Object> kv = new HashMap<String, Object>();

    public RelaxedPropertyResolver(Properties properties, String prefix) {
        this.properties = properties;
        this.prefix = prefix;
        this.init();
    }

    private void init() {
        Set<Object> keySets = this.properties.keySet();
        if (keySets != null && !keySets.isEmpty()) {
            for (Object key : keySets) {
                if (!key.toString().startsWith(this.prefix)) continue;
                this.kv.put(key.toString(), this.properties.get(key));
            }
        }
    }

    public String getProperty(String key) {
        return this.getProperty(key, null);
    }

    public String getProperty(String key, String defaultValue) {
        String realKey = this.prefix + key;
        Object value = this.kv.get(realKey);
        if (value == null) {
            return defaultValue;
        }
        return value.toString();
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> kv = new HashMap<String, Object>();
        if (this.kv != null) {
            this.kv.forEach((k, v) -> {
                int len = this.prefix.endsWith(".") ? this.prefix.length() : this.prefix.length() + 1;
                String truelyKey = k.substring(len);
                kv.put(truelyKey, v);
            });
        }
        return kv;
    }

    public Map<String, Object> getSubProperties(String keyPrefix) {
        String fullPrefix = this.prefix + keyPrefix;
        HashMap<String, Object> kvtmp = new HashMap<String, Object>();
        Set<Object> keySets = this.properties.keySet();
        if (keySets != null && !keySets.isEmpty()) {
            for (Object key : keySets) {
                if (!key.toString().startsWith(fullPrefix)) continue;
                String shotKey = key.toString().replaceFirst(fullPrefix, "");
                kvtmp.put(shotKey, this.properties.get(key));
            }
        }
        return kvtmp;
    }
}

