/*
 * Decompiled with CFR 0.152.
 */
package cn.t.common.rpc;

import cn.t.common.rpc.RpcResult;
import cn.t.common.service.ErrorInfoEnum;
import cn.t.common.service.ServiceException;
import java.util.List;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.servlet.NoHandlerFoundException;

public class FeignRpcService {
    private final Logger logger = LoggerFactory.getLogger(FeignRpcService.class);

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public RpcResult<Object> methodArgumentNotValid(MethodArgumentNotValidException e) {
        BindingResult bindingResult = e.getBindingResult();
        TreeMap<String, String> fieldErrorMap = this.buildErrorField(bindingResult);
        RpcResult<Object> result = fieldErrorMap.size() > 0 && fieldErrorMap.firstEntry() != null ? RpcResult.buildFail(ErrorInfoEnum.BAD_PARAM.errorInfo.getCode(), fieldErrorMap.firstEntry().getValue(), fieldErrorMap) : RpcResult.buildFail(ErrorInfoEnum.BAD_PARAM.errorInfo);
        this.logger.error("cat a MethodArgumentNotValidException, {}", result);
        return result;
    }

    @ExceptionHandler(value={BindException.class})
    public RpcResult<Object> methodArgumentNotValid(BindException e) {
        BindingResult bindingResult = e.getBindingResult();
        RpcResult<Object> result = RpcResult.buildFail(ErrorInfoEnum.BAD_PARAM.errorInfo, this.buildErrorField(bindingResult));
        this.logger.error("cat a BindException, {}", result);
        return result;
    }

    private TreeMap<String, String> buildErrorField(BindingResult bindingResult) {
        List objectErrorList = bindingResult.getAllErrors();
        TreeMap<String, String> errorFieldMap = new TreeMap<String, String>();
        objectErrorList.forEach(error -> {
            if (error instanceof FieldError) {
                errorFieldMap.put(((FieldError)error).getField(), error.getDefaultMessage());
            }
        });
        return errorFieldMap;
    }

    @ExceptionHandler(value={NoHandlerFoundException.class})
    public RpcResult<Object> noHandlerFound(NoHandlerFoundException e) {
        this.logger.error("cat a NoHandlerFoundException", (Throwable)e);
        return RpcResult.buildFail(ErrorInfoEnum.SOURCE_NOT_FOUND.errorInfo);
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    public RpcResult<Object> messageNotReadable(HttpMessageNotReadableException e) {
        this.logger.error("cat a HttpMessageNotReadableException", (Throwable)e);
        return RpcResult.buildFail(ErrorInfoEnum.BAD_PARAM.errorInfo);
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    public RpcResult<Object> methodNotSupport(HttpRequestMethodNotSupportedException e) {
        this.logger.error("cat a HttpRequestMethodNotSupportedException", (Throwable)e);
        return RpcResult.buildFail(ErrorInfoEnum.METHOD_NOT_SUPPORT.errorInfo);
    }

    @ExceptionHandler(value={ServiceException.class})
    public RpcResult<Object> exception(ServiceException e) {
        if (StringUtils.isEmpty((Object)e.getCode())) {
            this.logger.warn("\u4e1a\u52a1\u5f02\u5e38, errorCode is null", (Throwable)e);
            return RpcResult.buildFail(ErrorInfoEnum.SERVER_INTERNAL_ERROR.errorInfo);
        }
        this.logger.warn("\u4e1a\u52a1\u5f02\u5e38, code: {}, msg: {}, data: {}", new Object[]{e.getCode(), e.getMessage(), e.getData()});
        return RpcResult.buildFail(e.getCode(), e.getMessage(), e.getData());
    }

    @ExceptionHandler(value={Throwable.class})
    public RpcResult<Object> exception(Throwable t) {
        this.logger.error("catch a exception", t);
        return RpcResult.buildFail(ErrorInfoEnum.SERVER_INTERNAL_ERROR.errorInfo);
    }
}

