/*
 * Decompiled with CFR 0.152.
 */
package cn.t.common.rpc;

import cn.t.common.service.ErrorInfo;
import java.io.Serializable;

public class RpcResult<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SUCCESS = "200";
    public static final String FAIL = "500";
    private String code;
    private String message;
    private T data;

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public String toString() {
        return "RpcResult{code='" + this.code + '\'' + ", message='" + this.message + '\'' + ", data=" + this.data + '}';
    }

    public static <T> RpcResult<T> buildSuccess() {
        return RpcResult.doBuild(SUCCESS, null, null);
    }

    public static <T> RpcResult<T> buildSuccess(T data) {
        return RpcResult.doBuild(SUCCESS, null, data);
    }

    public static <T> RpcResult<T> buildSystemError(String msg) {
        return RpcResult.buildFail(FAIL, msg);
    }

    public static <T> RpcResult<T> buildFail(String errorCode) {
        return RpcResult.buildFail(errorCode, null);
    }

    public static <T> RpcResult<T> buildFail(String errorCode, String message) {
        return RpcResult.buildFail(errorCode, message, null);
    }

    public static <T> RpcResult<T> buildFail(String errorCode, T data) {
        return RpcResult.buildFail(errorCode, null, data);
    }

    public static <T> RpcResult<T> buildFail(ErrorInfo errorInfo) {
        return RpcResult.buildFail(errorInfo, null);
    }

    public static <T> RpcResult<T> buildFail(ErrorInfo errorInfo, T data) {
        return RpcResult.buildFail(errorInfo.getCode(), errorInfo.getMsg(), data);
    }

    public static <T> RpcResult<T> buildFail(String errorCode, String message, T data) {
        return RpcResult.doBuild(errorCode, message, data);
    }

    private static <T> RpcResult<T> doBuild(String code, String message, T data) {
        RpcResult<T> result = new RpcResult<T>();
        result.setCode(code);
        result.setMessage(message);
        result.setData(data);
        return result;
    }
}

