package cn.takujo.common_api.util;

import java.util.Map;

import cn.takujo.common_api.exception.BaseException;
import lombok.Data;
import lombok.NonNull;

/**
 * 和风天气接口调用
 * 
 * @author wzx
 *
 */
@Data
public final class HeWeather {

	/**
	 * 用户认证的key
	 */
	@NonNull
	private String key;

	/**
	 * 实时天气
	 * 
	 * @param location
	 *            需要查询的城市或地区，可输入以下值： 1. 城市ID：城市列表 --location=CN101010100 2.
	 *            经纬度格式：经度,纬度（经度在前纬度在后，英文,分隔，十进制格式，北纬东经为正，南纬西经为负
	 *            --location=116.40,39.9 3. 城市名称，支持中英文和汉语拼音 --location=北京、
	 *            location=北京市、 location=beijing 4. 城市名称，上级城市 或 省 或
	 *            国家，英文,分隔，此方式可以在重名的情况下只获取想要的地区的天气数据，例如 西安,陕西 --location=朝阳,北京、
	 *            location=chaoyang,beijing 5. IP --location=60.194.130.1 6.
	 *            根据请求自动判断，根据用户的请求获取IP，通过 IP 定位并获取城市数据 --location=auto_ip
	 * @return map 字段详解见官方文档
	 * @throws BaseException
	 *             获取实时天气失败
	 */
	public Map<String, Object> now(String location) throws BaseException {
		String url = "https://free-api.heweather.com/s6/weather/now?key=" + key + "&location=" + location;
		try {
			String string = HttpUtil.get(url);
			return JsonUtil.toMap(string);
		} catch (BaseException e) {
			throw new BaseException(e.getErrCode(), "获取实时天气失败");
		}
	}

}
