package cn.takujo.common_api.util;

import java.util.Map;

import cn.takujo.common_api.exception.HttpException;
import cn.takujo.common_api.exception.JsonException;
import lombok.Data;
import lombok.NonNull;
import lombok.RequiredArgsConstructor;

/**
 * 腾讯地图服务
 * 
 * @author wzx
 *
 */
@RequiredArgsConstructor
@Data
public final class TencentLocationUtil {

	/**
	 * 腾讯地图开发者的key
	 */
	@NonNull
	private String key;
	private static final String URL = "https://apis.map.qq.com/ws/geocoder/v1/";

	/**
	 * 首选地址（腾讯地图推荐的地址）
	 * 
	 * @param lat
	 *            纬度
	 * @param lng
	 *            经度
	 * @return 返回首选地址，无匹配则返回空字符串
	 */
	@SuppressWarnings("unchecked")
	public String recommendAddress(String lat, String lng) {
		String location = lat + "," + lng;
		try {
			String str = HttpUtil.get(URL + "?location=" + location + "&key=" + key);
			Map<String, Object> map = JsonUtil.toMap(str);
			Map<String, Object> result = (Map<String, Object>) map.get("result");
			Map<String, Object> formatted_addresses = (Map<String, Object>) result.get("formatted_addresses");
			String address = (String) result.get("address");
			String recommend = (String) formatted_addresses.get("recommend");
			return address + recommend;
		} catch (HttpException e) {
			e.printStackTrace();
		} catch (JsonException e) {
			e.printStackTrace();
		}
		return "";
	}

}
