/*
 * Decompiled with CFR 0.152.
 */
package cn.teleinfo.idhub.sdk;

import java.util.ArrayList;
import java.util.List;
import org.springframework.core.SpringProperties;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.ResourceHttpMessageConverter;
import org.springframework.http.converter.ResourceRegionHttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.cbor.MappingJackson2CborHttpMessageConverter;
import org.springframework.http.converter.feed.AtomFeedHttpMessageConverter;
import org.springframework.http.converter.feed.RssChannelHttpMessageConverter;
import org.springframework.http.converter.json.GsonHttpMessageConverter;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.http.converter.json.JsonbHttpMessageConverter;
import org.springframework.http.converter.json.KotlinSerializationJsonHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.http.converter.smile.MappingJackson2SmileHttpMessageConverter;
import org.springframework.http.converter.support.AllEncompassingFormHttpMessageConverter;
import org.springframework.http.converter.xml.Jaxb2RootElementHttpMessageConverter;
import org.springframework.http.converter.xml.MappingJackson2XmlHttpMessageConverter;
import org.springframework.http.converter.xml.SourceHttpMessageConverter;
import org.springframework.util.ClassUtils;

public class WebMvcConfigHelper {
    private List<HttpMessageConverter<?>> messageConverters;
    private static final boolean shouldIgnoreXml = SpringProperties.getFlag((String)"spring.xml.ignore");
    private static final boolean romePresent;
    private static final boolean jaxb2Present;
    private static final boolean jackson2Present;
    private static final boolean jackson2XmlPresent;
    private static final boolean jackson2SmilePresent;
    private static final boolean jackson2CborPresent;
    private static final boolean gsonPresent;
    private static final boolean jsonbPresent;
    private static final boolean kotlinSerializationJsonPresent;

    public List<HttpMessageConverter<?>> getMessageConverters() {
        if (this.messageConverters == null) {
            this.messageConverters = new ArrayList();
            if (this.messageConverters.isEmpty()) {
                this.addDefaultHttpMessageConverters(this.messageConverters);
            }
        }
        return this.messageConverters;
    }

    private void addDefaultHttpMessageConverters(List<HttpMessageConverter<?>> messageConverters) {
        Jackson2ObjectMapperBuilder builder;
        messageConverters.add((HttpMessageConverter<?>)new ByteArrayHttpMessageConverter());
        messageConverters.add((HttpMessageConverter<?>)new StringHttpMessageConverter());
        messageConverters.add((HttpMessageConverter<?>)new ResourceHttpMessageConverter());
        messageConverters.add((HttpMessageConverter<?>)new ResourceRegionHttpMessageConverter());
        if (!shouldIgnoreXml) {
            try {
                messageConverters.add((HttpMessageConverter<?>)new SourceHttpMessageConverter());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        messageConverters.add((HttpMessageConverter<?>)new AllEncompassingFormHttpMessageConverter());
        if (romePresent) {
            messageConverters.add((HttpMessageConverter<?>)new AtomFeedHttpMessageConverter());
            messageConverters.add((HttpMessageConverter<?>)new RssChannelHttpMessageConverter());
        }
        if (!shouldIgnoreXml) {
            if (jackson2XmlPresent) {
                builder = Jackson2ObjectMapperBuilder.xml();
                messageConverters.add((HttpMessageConverter<?>)new MappingJackson2XmlHttpMessageConverter(builder.build()));
            } else if (jaxb2Present) {
                messageConverters.add((HttpMessageConverter<?>)new Jaxb2RootElementHttpMessageConverter());
            }
        }
        if (kotlinSerializationJsonPresent) {
            messageConverters.add((HttpMessageConverter<?>)new KotlinSerializationJsonHttpMessageConverter());
        }
        if (jackson2Present) {
            builder = Jackson2ObjectMapperBuilder.json();
            messageConverters.add((HttpMessageConverter<?>)new MappingJackson2HttpMessageConverter(builder.build()));
        } else if (gsonPresent) {
            messageConverters.add((HttpMessageConverter<?>)new GsonHttpMessageConverter());
        } else if (jsonbPresent) {
            messageConverters.add((HttpMessageConverter<?>)new JsonbHttpMessageConverter());
        }
        if (jackson2SmilePresent) {
            builder = Jackson2ObjectMapperBuilder.smile();
            messageConverters.add((HttpMessageConverter<?>)new MappingJackson2SmileHttpMessageConverter(builder.build()));
        }
        if (jackson2CborPresent) {
            builder = Jackson2ObjectMapperBuilder.cbor();
            messageConverters.add((HttpMessageConverter<?>)new MappingJackson2CborHttpMessageConverter(builder.build()));
        }
    }

    static {
        ClassLoader classLoader = WebMvcConfigHelper.class.getClassLoader();
        romePresent = ClassUtils.isPresent((String)"com.rometools.rome.feed.WireFeed", (ClassLoader)classLoader);
        jaxb2Present = ClassUtils.isPresent((String)"javax.xml.bind.Binder", (ClassLoader)classLoader);
        jackson2Present = ClassUtils.isPresent((String)"com.fasterxml.jackson.databind.ObjectMapper", (ClassLoader)classLoader) && ClassUtils.isPresent((String)"com.fasterxml.jackson.core.JsonGenerator", (ClassLoader)classLoader);
        jackson2XmlPresent = ClassUtils.isPresent((String)"com.fasterxml.jackson.dataformat.xml.XmlMapper", (ClassLoader)classLoader);
        jackson2SmilePresent = ClassUtils.isPresent((String)"com.fasterxml.jackson.dataformat.smile.SmileFactory", (ClassLoader)classLoader);
        jackson2CborPresent = ClassUtils.isPresent((String)"com.fasterxml.jackson.dataformat.cbor.CBORFactory", (ClassLoader)classLoader);
        gsonPresent = ClassUtils.isPresent((String)"com.google.gson.Gson", (ClassLoader)classLoader);
        jsonbPresent = ClassUtils.isPresent((String)"javax.json.bind.Jsonb", (ClassLoader)classLoader);
        kotlinSerializationJsonPresent = ClassUtils.isPresent((String)"kotlinx.serialization.json.Json", (ClassLoader)classLoader);
    }
}

