/*
 * Decompiled with CFR 0.152.
 */
package cn.teleinfo.idhub.sdk.client;

import cn.teleinfo.idhub.manage.doip.server.api.auth.ChallengeResponseApi;
import cn.teleinfo.idhub.manage.doip.server.api.dataauth.DataAuthorizationApi;
import cn.teleinfo.idhub.manage.doip.server.api.dataauth.HandleUserApi;
import cn.teleinfo.idhub.manage.doip.server.api.file.FileApi;
import cn.teleinfo.idhub.manage.doip.server.api.instance.InstanceApi;
import cn.teleinfo.idhub.manage.doip.server.api.message.MessageCenterApi;
import cn.teleinfo.idhub.manage.doip.server.api.meta.MetaApi;
import cn.teleinfo.idhub.manage.doip.server.domain.DoipReturn;
import cn.teleinfo.idhub.manage.doip.server.dto.auth.VerifyResponseDTO;
import cn.teleinfo.idhub.manage.doip.server.enums.DoipClientCodeEnum;
import cn.teleinfo.idhub.sdk.WebMvcConfigHelper;
import cn.teleinfo.idhub.sdk.interceptor.AuthInterceptor;
import cn.teleinfo.idhub.sdk.utils.EncryptionUtils;
import cn.teleinfo.idhub.sdk.utils.KeyConverter;
import feign.Contract;
import feign.Feign;
import feign.RequestInterceptor;
import feign.Retryer;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.jackson.JacksonDecoder;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.cloud.openfeign.support.ResponseEntityDecoder;
import org.springframework.cloud.openfeign.support.SpringEncoder;
import org.springframework.cloud.openfeign.support.SpringMvcContract;

public class OpenApiClient {
    private static final Logger log = LoggerFactory.getLogger(OpenApiClient.class);
    private JacksonDecoder decoder = new JacksonDecoder();
    private ResponseEntityDecoder responseEntityDecoder = new ResponseEntityDecoder((Decoder)this.decoder);
    private WebMvcConfigHelper webMvcConfigHelper = new WebMvcConfigHelper();
    private ObjectFactory<HttpMessageConverters> objectFactory = new ObjectFactory<HttpMessageConverters>(){
        private HttpMessageConverters httpMessageConverters;
        {
            this.httpMessageConverters = new HttpMessageConverters(OpenApiClient.this.webMvcConfigHelper.getMessageConverters());
        }

        public HttpMessageConverters getObject() throws BeansException {
            return this.httpMessageConverters;
        }
    };
    private SpringEncoder encoder = new SpringEncoder(this.objectFactory);
    private SpringMvcContract contract = new SpringMvcContract();
    private ChallengeResponseApi challengeResponseApi;
    private InstanceApi instanceApi;
    private FileApi fileApi;
    private MetaApi metaApi;
    private DataAuthorizationApi dataAuthorizationApi;
    private HandleUserApi handleUserApi;
    private MessageCenterApi messageApi;

    public OpenApiClient() {
    }

    public OpenApiClient(String url, String handle, String privateKeyPem) {
        this();
        log.info("{} \u5f00\u59cb\u6311\u6218", (Object)handle);
        this.challengeResponseApi = (ChallengeResponseApi)Feign.builder().encoder((Encoder)this.encoder).decoder((Decoder)this.responseEntityDecoder).contract((Contract)this.contract).retryer(Retryer.NEVER_RETRY).target(ChallengeResponseApi.class, url);
        String token = this.authenticate(handle, privateKeyPem);
        this.instanceApi = (InstanceApi)Feign.builder().encoder((Encoder)this.encoder).decoder((Decoder)this.responseEntityDecoder).contract((Contract)this.contract).retryer(Retryer.NEVER_RETRY).requestInterceptor((RequestInterceptor)new AuthInterceptor(token)).target(InstanceApi.class, url);
        this.fileApi = (FileApi)Feign.builder().encoder((Encoder)this.encoder).decoder((Decoder)this.responseEntityDecoder).contract((Contract)this.contract).retryer(Retryer.NEVER_RETRY).requestInterceptor((RequestInterceptor)new AuthInterceptor(token)).target(FileApi.class, url);
        this.metaApi = (MetaApi)Feign.builder().encoder((Encoder)this.encoder).decoder((Decoder)this.responseEntityDecoder).contract((Contract)this.contract).retryer(Retryer.NEVER_RETRY).requestInterceptor((RequestInterceptor)new AuthInterceptor(token)).target(MetaApi.class, url);
        this.dataAuthorizationApi = (DataAuthorizationApi)Feign.builder().encoder((Encoder)this.encoder).decoder((Decoder)this.responseEntityDecoder).contract((Contract)this.contract).retryer(Retryer.NEVER_RETRY).requestInterceptor((RequestInterceptor)new AuthInterceptor(token)).target(DataAuthorizationApi.class, url);
        this.handleUserApi = (HandleUserApi)Feign.builder().encoder((Encoder)this.encoder).decoder((Decoder)this.responseEntityDecoder).contract((Contract)this.contract).retryer(Retryer.NEVER_RETRY).requestInterceptor((RequestInterceptor)new AuthInterceptor(token)).target(HandleUserApi.class, url);
        this.messageApi = (MessageCenterApi)Feign.builder().encoder((Encoder)this.encoder).decoder((Decoder)this.responseEntityDecoder).contract((Contract)this.contract).retryer(Retryer.NEVER_RETRY).requestInterceptor((RequestInterceptor)new AuthInterceptor(token)).target(MessageCenterApi.class, url);
    }

    private String authenticate(String handle, String privateKeyPem) {
        try {
            DoipReturn challengeResponse = this.challengeResponseApi.challenge(handle);
            String random = (String)challengeResponse.getData();
            PrivateKey privateKey = KeyConverter.fromPkcs8Pem(privateKeyPem);
            String sign = EncryptionUtils.sign(random.getBytes(StandardCharsets.UTF_8), privateKey);
            VerifyResponseDTO verifyResponseDTO = new VerifyResponseDTO();
            verifyResponseDTO.setHandle(handle);
            verifyResponseDTO.setSignature(sign);
            DoipReturn verifyResponse = this.challengeResponseApi.verifyResponse(verifyResponseDTO);
            if (!Objects.equals(verifyResponse.getCode(), DoipClientCodeEnum.SUCCESS.getCode())) {
                throw new RuntimeException("\u6311\u6218\u5931\u8d25");
            }
            log.info("{} \u6311\u6218\u5e94\u7b54\u6210\u529f\uff01", (Object)handle);
            return ((Map)verifyResponse.getData()).get("token").toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String challenge(String handle, String url) {
        this.challengeResponseApi = (ChallengeResponseApi)Feign.builder().encoder((Encoder)this.encoder).decoder((Decoder)this.responseEntityDecoder).contract((Contract)this.contract).retryer(Retryer.NEVER_RETRY).target(ChallengeResponseApi.class, url);
        DoipReturn challengeResponse = this.challengeResponseApi.challenge(handle);
        String random = (String)challengeResponse.getData();
        log.info("{} \u6311\u6218\u6210\u529f\uff01\u8fd4\u56de\u7ed3\u679c{}", (Object)handle, (Object)challengeResponse);
        return random;
    }

    public InstanceApi getIntanceApi() {
        return this.instanceApi;
    }

    public FileApi getFileApi() {
        return this.fileApi;
    }

    public MetaApi getMetaApi() {
        return this.metaApi;
    }

    public DataAuthorizationApi getDataAuthorizationApi() {
        return this.dataAuthorizationApi;
    }

    public HandleUserApi getHandleUserApi() {
        return this.handleUserApi;
    }

    public MessageCenterApi getMessageApi() {
        return this.messageApi;
    }
}

