/*
 * Decompiled with CFR 0.152.
 */
package cn.teleinfo.idhub.sdk.utils;

import cn.teleinfo.idhub.sdk.utils.KeyConverter;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.util.Base64;
import javax.crypto.Cipher;

public abstract class EncryptionUtils {
    public static final String KEY_ALGORITHM = "RSA";
    public static final String SIGNATURE_ALGORITHM = "SHA256withRSA";

    public static KeyPair generateKeyPair() throws NoSuchAlgorithmException {
        KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance(KEY_ALGORITHM);
        keyPairGen.initialize(2048);
        return keyPairGen.generateKeyPair();
    }

    public static String sign(byte[] data, PrivateKey privateKey) throws Exception {
        Signature signature = Signature.getInstance(SIGNATURE_ALGORITHM);
        signature.initSign(privateKey);
        signature.update(data);
        return Base64.getEncoder().encodeToString(signature.sign());
    }

    public static boolean verify(byte[] data, PublicKey pubKey, String sign) throws Exception {
        Signature signature = Signature.getInstance(SIGNATURE_ALGORITHM);
        signature.initVerify(pubKey);
        signature.update(data);
        return signature.verify(EncryptionUtils.decodeBASE64(sign));
    }

    public static byte[] decodeBASE64(String source) {
        return Base64.getMimeDecoder().decode(source);
    }

    public static String encodeBASE64(byte[] data) {
        return Base64.getMimeEncoder().encodeToString(data);
    }

    public static byte[] decryptByKey(byte[] data, Key key) throws Exception {
        Cipher cipher = Cipher.getInstance(key.getAlgorithm());
        cipher.init(2, key);
        return cipher.doFinal(data);
    }

    public static byte[] encryptByKey(byte[] data, Key key) throws Exception {
        Cipher cipher = Cipher.getInstance(key.getAlgorithm());
        cipher.init(1, key);
        return cipher.doFinal(data);
    }

    public static byte[] decryptByKey(byte[] data, Key key, String algorithm) throws Exception {
        Cipher cipher = Cipher.getInstance(algorithm);
        cipher.init(2, key);
        return cipher.doFinal(data);
    }

    public static byte[] encryptByKey(byte[] data, Key key, String algorithm) throws Exception {
        Cipher cipher = Cipher.getInstance(algorithm);
        cipher.init(1, key);
        return cipher.doFinal(data);
    }

    public static String getEncryptionPassword(String oriPasswordStr, String publicKeyPem) throws Exception {
        byte[] oriPasswordBytes = oriPasswordStr.getBytes(StandardCharsets.UTF_8);
        PublicKey publicKey = KeyConverter.fromX509Pem(publicKeyPem);
        byte[] bytes = EncryptionUtils.encryptByKey(oriPasswordBytes, publicKey, "RSA/ECB/OAEPWITHSHA-256ANDMGF1PADDING");
        return Base64.getEncoder().encodeToString(bytes);
    }
}

