/*
 * Decompiled with CFR 0.152.
 */
package com.therouter.plugin.utils;

import com.therouter.plugin.Node;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TheRouterPluginUtils {
    private static final List<String> loopDependStack = new ArrayList<String>();
    public static Set<String> dependStack = new HashSet<String>();

    public static String getLog(List<String> list, String root) {
        if (list == null || list.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String task : list) {
            stringBuilder.append(task).append("-->");
        }
        if (root != null) {
            stringBuilder.append(root);
        }
        return stringBuilder.toString();
    }

    public static void fillTodoList(Map<String, Set<String>> map, String root) {
        Set<String> dependsSet = map.get(root);
        if (dependsSet != null && !dependsSet.isEmpty()) {
            if (loopDependStack.contains(root)) {
                throw new RuntimeException("\n\n==========================================\nTheRouter:: FlowTask::   \nCyclic dependency: [" + TheRouterPluginUtils.getLog(loopDependStack, root) + "]\n==========================================\n\n");
            }
            loopDependStack.add(root);
            for (String depend : dependsSet) {
                TheRouterPluginUtils.fillTodoList(map, depend);
            }
            loopDependStack.remove(root);
        }
    }

    public static void fillNode(Node node, String root) {
        if (node.getChildren() == null || node.getChildren().isEmpty()) {
            if (root == null) {
                dependStack.add(node.getName());
            } else {
                dependStack.add(node.getName() + " --> " + root);
            }
        } else {
            for (Node it : node.getChildren()) {
                if (root == null) {
                    TheRouterPluginUtils.fillNode(it, node.getName());
                    continue;
                }
                TheRouterPluginUtils.fillNode(it, node.getName() + " --> " + root);
            }
        }
    }

    public static Node createNode(Map<String, Set<String>> map, String root) {
        Node node = new Node(root);
        HashSet<Node> childrenNode = new HashSet<Node>();
        Set<String> dependsSet = map.get(root);
        if (dependsSet != null && !dependsSet.isEmpty()) {
            for (String depend : dependsSet) {
                childrenNode.add(TheRouterPluginUtils.createNode(map, depend));
            }
        }
        node.setChildren(childrenNode);
        return node;
    }
}

