package cn.virens.common;

import java.util.Collection;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Closeable 工具类，适用于各种流的关闭操作
 * 
 * @author : virens
 */
public class CloseableUtil {
	private final static Logger logger = LoggerFactory.getLogger(CloseableUtil.class);

	/**
	 * 关闭实现AutoCloseable的对象
	 * 
	 * @param closeable AutoCloseable实现对象
	 */
	public static void close(AutoCloseable closeable) {
		if (closeable == null) return;

		try {
			closeable.close();
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
		}
	}

	/**
	 * 关闭实现AutoCloseable的对象
	 * 
	 * @param closeables AutoCloseable实现对象
	 */
	public static void closes(Collection<? extends AutoCloseable> closeables) {
		if (closeables == null) return;

		for (AutoCloseable closeable : closeables) {
			CloseableUtil.close(closeable);
		}
	}

	/**
	 * 关闭实现AutoCloseable的对象
	 * 
	 * @param closeables AutoCloseable实现对象
	 */
	public static void closes(AutoCloseable... closeables) {
		for (AutoCloseable closeable : closeables) {
			CloseableUtil.close(closeable);
		}
	}
}
