package cn.virens.common;

import java.util.Date;
import java.util.Map;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.date.DateUtil;

/**
 * Map 工具类，从Map 中获取不同类型的值
 * 
 * @author : virens
 */
public class MapUtil extends cn.hutool.core.map.MapUtil {
	/**
	 * 获取类型为 Object 的值
	 * 
	 * @param  map          Map对象
	 * @param  key          键
	 * @param  defaultValue 默认值
	 * @return              返回值
	 */
	public static Object getObject(final Map<?, ?> map, final Object key, final Object defaultValue) {
		if (map == null) return defaultValue;

		Object answer = map.get(key);

		if (answer != null) {
			return answer;
		} else {
			return defaultValue;
		}
	}

	/**
	 * 获取类型为 String 的值
	 * 
	 * @param  map          Map对象
	 * @param  key          键
	 * @param  defaultValue 默认值
	 * @return              返回值
	 */
	public static String getString(final Map<?, ?> map, final Object key, final String defaultValue) {
		Object answer = getObject(map, key, defaultValue);

		try {
			if (answer != null) {
				return answer.toString();
			} else {
				return defaultValue;
			}
		} catch (Exception e) {
		}

		return defaultValue;
	}

	/**
	 * 获取类型为 Boolean 返回值
	 * 
	 * @param  map          Map对象
	 * @param  key          键
	 * @param  defaultValue 默认值
	 * @return              返回值
	 */
	public static Boolean getBoolean(final Map<?, ?> map, final Object key, final Boolean defaultValue) {
		Object answer = getObject(map, key, defaultValue);

		try {
			if (answer instanceof Boolean) {
				return (Boolean) answer;
			} else if (answer instanceof String) {
				return StringUtil.equalsAnyIgnoreCase(answer.toString(), "true", "on", "1");
			} else if (answer instanceof Number) {
				return (((Number) answer).intValue() != 0) ? Boolean.TRUE : Boolean.FALSE;
			} else {
				return defaultValue;
			}
		} catch (Exception e) {
		}

		return defaultValue;
	}

	/**
	 * 获取类型为 Byte 的值
	 * 
	 * @param  map          Map对象
	 * @param  key          键
	 * @param  defaultValue 默认值
	 * @return              返回值
	 */
	public static Byte getByte(final Map<?, ?> map, final Object key, final Byte defaultValue) {
		Object answer = getObject(map, key, defaultValue);

		try {
			if (answer instanceof Number) {
				return Byte.valueOf(((Number) answer).byteValue());
			} else if (answer instanceof String) {
				return Convert.toByte(answer, defaultValue);
			} else {
				return defaultValue;
			}
		} catch (Exception e) {
		}

		return defaultValue;
	}

	/**
	 * 获取类型为 Short 的值
	 * 
	 * @param  map          Map对象
	 * @param  key          键
	 * @param  defaultValue 默认值
	 * @return              返回值
	 */
	public static Short getShort(final Map<?, ?> map, final Object key, final Short defaultValue) {
		Object answer = getObject(map, key, defaultValue);

		try {
			if (answer instanceof Number) {
				return Short.valueOf(((Number) answer).shortValue());
			} else if (answer instanceof String) {
				return Convert.toShort(answer, defaultValue);
			} else {
				return defaultValue;
			}
		} catch (Exception e) {
		}

		return defaultValue;
	}

	/**
	 * 获取类型为 Integer 的值
	 * 
	 * @param  map          Map对象
	 * @param  key          键
	 * @param  defaultValue 默认值
	 * @return              返回值
	 */
	public static Integer getInteger(final Map<?, ?> map, final Object key, final Integer defaultValue) {
		Object answer = getObject(map, key, defaultValue);

		try {
			if (answer instanceof Number) {
				return Integer.valueOf(((Number) answer).intValue());
			} else if (answer instanceof String) {
				return Convert.toInt(answer, defaultValue);
			} else if (answer instanceof Boolean) {
				return (Boolean) answer ? 1 : 0;
			} else {
				return defaultValue;
			}
		} catch (Exception e) {
		}

		return defaultValue;
	}

	/**
	 * 获取类型为 Long 的值
	 * 
	 * @param  map          Map对象
	 * @param  key          键
	 * @param  defaultValue 默认值
	 * @return              返回值
	 */
	public static Long getLong(final Map<?, ?> map, final Object key, final Long defaultValue) {
		Object answer = getObject(map, key, defaultValue);

		try {
			if (answer instanceof Number) {
				return Long.valueOf(((Number) answer).longValue());
			} else if (answer instanceof String) {
				return Convert.toLong(answer, defaultValue);
			} else if (answer instanceof Boolean) {
				return (Boolean) answer ? 1L : 0L;
			} else {
				return defaultValue;
			}
		} catch (Exception e) {
		}

		return defaultValue;
	}

	/**
	 * 获取类型为 Float 的值
	 * 
	 * @param  map          Map对象
	 * @param  key          键
	 * @param  defaultValue 默认值
	 * @return              返回值
	 */
	public static Float getFloat(final Map<?, ?> map, final Object key, final Float defaultValue) {
		Object answer = getObject(map, key, defaultValue);

		try {
			if (answer instanceof Number) {
				return Float.valueOf(((Number) answer).floatValue());
			} else if (answer instanceof String) {
				return Convert.toFloat(answer, defaultValue);
			} else if (answer instanceof Boolean) {
				return (Boolean) answer ? 1F : 0F;
			} else {
				return defaultValue;
			}
		} catch (Exception e) {
		}

		return defaultValue;
	}

	/**
	 * 获取类型为 Double 的值
	 * 
	 * @param  map          Map对象
	 * @param  key          键
	 * @param  defaultValue 默认值
	 * @return              返回值
	 */
	public static Double getDouble(final Map<?, ?> map, final Object key, final Double defaultValue) {
		Object answer = getObject(map, key, defaultValue);

		try {
			if (answer instanceof Number) {
				return Double.valueOf(((Number) answer).doubleValue());
			} else if (answer instanceof String) {
				return Convert.toDouble(answer, defaultValue);
			} else if (answer instanceof Boolean) {
				return (Boolean) answer ? 1D : 0D;
			} else {
				return defaultValue;
			}
		} catch (Exception e) {
		}

		return defaultValue;
	}

	/**
	 * 获取类型为 Date 的值
	 * 
	 * @param  map          Map对象
	 * @param  key          键
	 * @param  defaultValue 默认值
	 * @return              返回值
	 */
	public static Date getDate(final Map<?, ?> map, final Object key, final Date defaultValue) {
		Object answer = getObject(map, key, defaultValue);

		try {
			if (answer instanceof Date) {
				return (Date) answer;
			} else if (answer instanceof Number) {
				return new Date(((Number) answer).longValue());
			} else if (answer instanceof String) {
				return DateUtil.parse((String) answer);
			} else {
				return defaultValue;
			}
		} catch (Exception e) {
		}

		return defaultValue;
	}

	/**
	 * 获取类型为 Map 的值
	 * 
	 * @param  map          Map对象
	 * @param  key          键
	 * @param  defaultValue 默认值
	 * @return              返回值
	 */
	public static Map<?, ?> getMap(final Map<?, ?> map, final Object key, final Map<?, ?> defaultValue) {
		Object answer = getObject(map, key, defaultValue);

		try {
			if (answer instanceof Map) {
				return (Map<?, ?>) answer;
			} else {
				return defaultValue;
			}
		} catch (Exception e) {
		}

		return defaultValue;
	}

	/**
	 * 获取类型为 Object 的值,默认为null
	 * 
	 * @param  map Map对象
	 * @param  key 键
	 * @return     返回值
	 */
	public static Object getObject(final Map<?, ?> map, final Object key) {
		return getObject(map, key, null);
	}

	/**
	 * 获取类型为 String 的值,默认为null
	 * 
	 * @param  map Map对象
	 * @param  key 键
	 * @return     返回值
	 */
	public static String getString(final Map<?, ?> map, final Object key) {
		return getString(map, key, null);
	}

	/**
	 * 获取类型为 Boolean 返回值,默认为null
	 * 
	 * @param  map Map对象
	 * @param  key 键
	 * @return     返回值
	 */
	public static Boolean getBoolean(final Map<?, ?> map, final Object key) {
		return getBoolean(map, key, null);
	}

	/**
	 * 获取类型为 Byte 的值,默认为null
	 * 
	 * @param  map Map对象
	 * @param  key 键
	 * @return     返回值
	 */
	public static Byte getByte(final Map<?, ?> map, final Object key) {
		return getByte(map, key, null);
	}

	/**
	 * 获取类型为 Short 的值,默认为null
	 * 
	 * @param  map Map对象
	 * @param  key 键
	 * @return     返回值
	 */
	public static Short getShort(final Map<?, ?> map, final Object key) {
		return getShort(map, key, null);
	}

	/**
	 * 获取类型为 Integer 的值,默认为null
	 * 
	 * @param  map Map对象
	 * @param  key 键
	 * @return     返回值
	 */
	public static Integer getInteger(final Map<?, ?> map, final Object key) {
		return getInteger(map, key, null);
	}

	/**
	 * 获取类型为 Long 的值,默认为null
	 * 
	 * @param  map Map对象
	 * @param  key 键
	 * @return     返回值
	 */
	public static Long getLong(final Map<?, ?> map, final Object key) {
		return getLong(map, key, null);
	}

	/**
	 * 获取类型为 Float 的值,默认为null
	 * 
	 * @param  map Map对象
	 * @param  key 键
	 * @return     返回值
	 */
	public static Float getFloat(final Map<?, ?> map, final Object key) {
		return getFloat(map, key, null);
	}

	/**
	 * 获取类型为 Double 的值,默认为null
	 * 
	 * @param  map Map对象
	 * @param  key 键
	 * @return     返回值
	 */
	public static Double getDouble(final Map<?, ?> map, final Object key) {
		return getDouble(map, key, null);
	}

	/**
	 * 获取类型为 Date 的值,默认为null
	 * 
	 * @param  map Map对象
	 * @param  key 键
	 * @return     返回值
	 */
	public static Date getDate(final Map<?, ?> map, final Object key) {
		return getDate(map, key, null);
	}

	/**
	 * 获取类型为 Map 的值,默认为null
	 * 
	 * @param  map Map对象
	 * @param  key 键
	 * @return     返回值
	 */
	public static Map<?, ?> getMap(final Map<?, ?> map, final Object key) {
		return getMap(map, key, null);
	}

	/**
	 * 获取类型为 boolean 返回值
	 * 
	 * @param  map          Map对象
	 * @param  key          键
	 * @param  defaultValue 默认值
	 * @return              返回值
	 */
	public static boolean getBooleanValue(final Map<?, ?> map, final Object key, boolean defaultValue) {
		return getBoolean(map, key, defaultValue).booleanValue();
	}

	/**
	 * 获取类型为 byte 的值
	 * 
	 * @param  map          Map对象
	 * @param  key          键
	 * @param  defaultValue 默认值
	 * @return              返回值
	 */
	public static byte getByteValue(final Map<?, ?> map, final Object key, byte defaultValue) {
		return getByte(map, key, defaultValue).byteValue();
	}

	/**
	 * 获取类型为 short 的值
	 * 
	 * @param  map          Map对象
	 * @param  key          键
	 * @param  defaultValue 默认值
	 * @return              返回值
	 */
	public static short getShortValue(final Map<?, ?> map, final Object key, short defaultValue) {
		return getShort(map, key, defaultValue).shortValue();
	}

	/**
	 * 获取类型为 int 的值
	 * 
	 * @param  map          Map对象
	 * @param  key          键
	 * @param  defaultValue 默认值
	 * @return              返回值
	 */
	public static int getIntValue(final Map<?, ?> map, final Object key, int defaultValue) {
		return getInteger(map, key, defaultValue).intValue();
	}

	/**
	 * 获取类型为 long 的值
	 * 
	 * @param  map          Map对象
	 * @param  key          键
	 * @param  defaultValue 默认值
	 * @return              返回值
	 */
	public static long getLongValue(final Map<?, ?> map, final Object key, long defaultValue) {
		return getLong(map, key, defaultValue).longValue();
	}

	/**
	 * 获取类型为 float 的值
	 * 
	 * @param  map          Map对象
	 * @param  key          键
	 * @param  defaultValue 默认值
	 * @return              返回值
	 */
	public static float getFloatValue(final Map<?, ?> map, final Object key, float defaultValue) {
		return getFloat(map, key, defaultValue).floatValue();
	}

	/**
	 * 获取类型为 double 的值
	 * 
	 * @param  map          Map对象
	 * @param  key          键
	 * @param  defaultValue 默认值
	 * @return              返回值
	 */
	public static double getDoubleValue(final Map<?, ?> map, final Object key, double defaultValue) {
		return getDouble(map, key, defaultValue).doubleValue();
	}

	/**
	 * 获取类型为 boolean 返回值,默认：false
	 * 
	 * @param  map Map对象
	 * @param  key 键
	 * @return     返回值
	 */
	public static boolean getBooleanValue(final Map<?, ?> map, final Object key) {
		return getBooleanValue(map, key, false);
	}

	/**
	 * 获取类型为 byte 的值,默认：0
	 * 
	 * @param  map Map对象
	 * @param  key 键
	 * @return     返回值
	 */
	public static byte getByteValue(final Map<?, ?> map, final Object key) {
		return getByteValue(map, key, (byte) 0);
	}

	/**
	 * 获取类型为 short 的值,默认：0
	 * 
	 * @param  map Map对象
	 * @param  key 键
	 * @return     返回值
	 */
	public static short getShortValue(final Map<?, ?> map, final Object key) {
		return getShortValue(map, key, (short) 0);
	}

	/**
	 * 获取类型为 int 的值,默认：0
	 * 
	 * @param  map Map对象
	 * @param  key 键
	 * @return     返回值
	 */
	public static int getIntValue(final Map<?, ?> map, final Object key) {
		return getIntValue(map, key, 0);
	}

	/**
	 * 获取类型为 long 的值,默认：0
	 * 
	 * @param  map Map对象
	 * @param  key 键
	 * @return     返回值
	 */
	public static long getLongValue(final Map<?, ?> map, final Object key) {
		return getLongValue(map, key, 0L);
	}

	/**
	 * 获取类型为 float 的值,默认：0
	 * 
	 * @param  map Map对象
	 * @param  key 键
	 * @return     返回值
	 */
	public static float getFloatValue(final Map<?, ?> map, final Object key) {
		return getFloatValue(map, key, 0F);
	}

	/**
	 * 获取类型为 double 的值,默认：0
	 * 
	 * @param  map Map对象
	 * @param  key 键
	 * @return     返回值
	 */
	public static double getDoubleValue(final Map<?, ?> map, final Object key) {
		return getDoubleValue(map, key, 0D);
	}
}
