package cn.virens.common;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import cn.hutool.core.thread.ThreadUtil;

/**
 * 线程工具
 * 
 * @author : loioi
 */
public class ThreadUtils extends ThreadUtil {
	private static final Logger logger = LoggerFactory.getLogger(ThreadUtils.class);

	/**
	 * 在公共线程池 执行运行抛出异常的线程
	 * 
	 * @param runnable 线程执行
	 */
	public static void execute0(ThreadRunnable runnable) {
		ThreadUtil.execute(runnable);
	}

	/**
	 * 线程-运行接口
	 * 
	 * @author : loioi
	 */
	public interface ThreadRunnable extends Runnable {
		public abstract void run0() throws Exception;

		@Override
		default void run() {
			try {
				run0();
			} catch (Exception e) {
				logger.error(e.getMessage(), e);
			}
		}
	}
}
