package cn.virens.components.page;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

import cn.virens.common.MapUtil;

/**
 * 分页查询
 * 
 * @author : virens
 */
public class PageParam implements Serializable {
	private static final long serialVersionUID = -3486086036835371165L;

	protected Integer pageNum;
	protected Integer pageSize;
	protected Boolean count = true;

	protected String orderBy;

	private Map<String, Object> params; // 参数

	public PageParam() {
	}

	public PageParam(Integer pageNum, Integer pageSize) {
		this.pageSize = pageSize;
		this.pageNum = pageNum;
	}

	public static PageParam of(Integer pageNum, Integer pageSize) {
		return new PageParam(pageNum, pageSize);
	}

	/**
	 * 是否开启统计总数
	 * 
	 * @return 是否开启统计总数
	 */
	public Boolean isCount() {
		return count;
	}

	/**
	 * 设置 是否开启统计总数
	 * 
	 * @param count 是否开启统计总数
	 */
	public void setCount(Boolean count) {
		this.count = count;
	}

	/**
	 * 获取当前页码
	 * 
	 * @return 当前页码
	 */
	public Integer getPageNum() {
		return pageNum;
	}

	/**
	 * 设置当前页码
	 * 
	 * @param pageNum 当前页码
	 */
	public void setPageNum(Integer pageNum) {
		this.pageNum = pageNum;
	}

	/**
	 * 获取每页条数
	 * 
	 * @return int
	 */
	public Integer getPageSize() {
		return pageSize;
	}

	/**
	 * 设置每页条数
	 * 
	 * @param pageSize 每页条数
	 */
	public void setPageSize(Integer pageSize) {
		this.pageSize = pageSize;
	}

	/**
	 * 获取 排序
	 * 
	 * @return orderBy
	 */
	public String getOrderBy() {
		return orderBy;
	}

	/**
	 * 设置 排序
	 * 
	 * @param orderBy 排序方式
	 */
	public void setOrderBy(String orderBy) {
		this.orderBy = orderBy;
	}

	/**
	 * 获取 查询参数
	 * 
	 * @param  key 键值
	 * @return     查询参数
	 */
	public String getParam(String key) {
		return getParam(key, null);
	}

	/**
	 * 获取 查询参数
	 * 
	 * @param  key          键值
	 * @param  defaultValue 默认值
	 * @return              查询参数
	 */
	public String getParam(String key, String defaultValue) {
		return MapUtil.getString(params, key, defaultValue);
	}

	/**
	 * 查询参数集
	 * 
	 * @return 查询参数集
	 */
	public Map<String, Object> getParams() {
		return params;
	}

	/**
	 * 设置 查询参数集
	 * 
	 * @param params 查询参数集
	 */
	public void setParams(Map<String, Object> params) {
		this.params = params;
	}

	/**
	 * 添加 查询参数
	 * 
	 * @param key   键值
	 * @param value 查询参数
	 */
	public void addParam(String key, Object value) {
		if (this.params == null) {
			this.params = new HashMap<>();
		}
		this.params.put(key, value);
	}

	@Override
	public String toString() {
		return "PageParam [page=" + pageNum + ", limit=" + pageSize + "]";
	}

}
