package cn.virens.components.page;

import javax.servlet.http.HttpServletRequest;

import cn.virens.common.RequestUtil;

/**
 * Layui Table 的分页数据包
 * 
 * @author : virens
 */
public class PageParamLayui extends PageParam {
	private static final long serialVersionUID = 1L;

	protected PageParamLayui(HttpServletRequest request) {
		this.setPageNum(RequestUtil.getValueInt(request, "page", 1));
		this.setPageSize(RequestUtil.getValueInt(request, "limit", 10));
	}

	protected PageParamLayui(int pageNum, int pageSize) {
		super(pageNum, pageSize);
	}

	public static PageParamLayui of(HttpServletRequest request) {
		return new PageParamLayui(request);
	}
}
