package cn.virens.components.page;

import javax.servlet.http.HttpServletRequest;

/**
 * 带有当前登录用户信息
 * 
 * @author virens
 */
public class PageParamUser extends PageParamLayui {
	private static final long serialVersionUID = 1L;

	private String role;
	private String account;

	protected PageParamUser(HttpServletRequest request) {
		super(request);
	}

	protected PageParamUser(int pageNum, int pageSize) {
		super(pageNum, pageSize);
	}

	public static PageParamUser of(int pageNum, int pageSize) {
		return new PageParamUser(pageNum, pageSize);
	}

	public static PageParamUser of(HttpServletRequest request) {
		return new PageParamUser(request);
	}

	public String getRole() {
		return role;
	}

	public void setRole(String role) {
		this.role = role;
	}

	public String getAccount() {
		return account;
	}

	public void setAccount(String account) {
		this.account = account;
	}

}
