package cn.virens.components.page;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class PageResult<T> implements Serializable {
	private static final long serialVersionUID = 1L;
	// 总页数
	private int pages;
	// 每页的数量
	private int pageSize;
	// 当前页
	private int pageNum;
	// 当前页的数量
	private int size;
	// 总记录数
	private long total;
	// 结果集
	private List<T> list;

	/**
	 * 获取 总页码数
	 * 
	 * @return int
	 */
	public int getPages() {
		return pages;
	}

	/**
	 * 设置 总页码数
	 * 
	 * @param pages 总页码数
	 */
	public void setPages(int pages) {
		this.pages = pages;
	}

	/**
	 * 获取 每页条数
	 * 
	 * @return int
	 */
	public int getPageSize() {
		return pageSize;
	}

	/**
	 * 设置 每页条数
	 * 
	 * @param pageSize 每页条数
	 */
	public void setPageSize(int pageSize) {
		this.pageSize = pageSize;
	}

	/**
	 * 获取 当前页码
	 * 
	 * @return int
	 */
	public int getPageNum() {
		return pageNum;
	}

	/**
	 * 设置 当前页码
	 * 
	 * @param pageNum 当前页码
	 */
	public void setPageNum(int pageNum) {
		this.pageNum = pageNum;
	}

	/**
	 * 获取 当前条数
	 * 
	 * @return int
	 */
	public int getSize() {
		return size;
	}

	/**
	 * 设置 当前条数
	 * 
	 * @param size 当前条数
	 */
	public void setSize(int size) {
		this.size = size;
	}

	/**
	 * 获取 总记录数
	 * 
	 * @return long
	 */
	public long getTotal() {
		return total;
	}

	/**
	 * 设置 总记录数
	 * 
	 * @param total 总记录数
	 */
	public void setTotal(long total) {
		this.total = total;
	}

	/**
	 * 是否是第一页
	 * 
	 * @return bolean
	 */
	public boolean isFirstPage() {
		return pageNum == 1;
	}

	/**
	 * 是否是最后一页
	 * 
	 * @return bolean
	 */
	public boolean isLastPage() {
		return pageNum == pages;
	}

	/**
	 * 获取 查询结果集
	 * 
	 * @return 查询结果集
	 */
	public List<T> getList() {
		return list;
	}

	/**
	 * 设置 查询结果集
	 * 
	 * @param list 查询结果集
	 */
	public void setList(List<T> list) {
		this.list = new ArrayList<>(list);
	}

}
