package cn.virens.components.poi.common;

import java.util.Date;

import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateUtil;

public class ReadUtil {
	public static CellStyle getCellStyle(Sheet sheet, int row, int cell) {
		return sheet == null ? null : getCellStyle(sheet.getRow(row), cell);
	}

	public static CellStyle getCellStyle(Row row, int cell) {
		return row == null ? null : getCellStyle(row.getCell(cell));
	}

	public static CellStyle getCellStyle(Cell cell) {
		return cell == null ? null : cell.getCellStyle();
	}

	public static String getString(Sheet sheet, int row, int cell) {
		return sheet == null ? null : getString(sheet.getRow(row), cell);
	}

	public static String getString(Row row, int cell) {
		return row == null ? null : getString(row.getCell(cell));
	}

	public static String getString(Cell cell) {
		if (cell == null) { return null; }

		CellType type = cell.getCellType();
		if (type == null) {
			return null;
		} else if (type == CellType.ERROR) {
			return "";
		} else if (type == CellType.FORMULA) {
			return cell.getCellFormula();
		} else if (type == CellType.STRING) {
			return cell.getStringCellValue();
		} else if (type == CellType.BOOLEAN) {
			return String.valueOf(cell.getBooleanCellValue());
		} else if (type == CellType.NUMERIC) {
			if (org.apache.poi.ss.usermodel.DateUtil.isCellDateFormatted(cell)) {
				return format(cell.getDateCellValue());
			} else {
				return String.valueOf(cell.getNumericCellValue());
			}
		} else {
			return null;
		}
	}

	public static Double getDouble(Sheet sheet, int row, int cell) {
		return sheet == null ? null : getDouble(sheet.getRow(row), cell);
	}

	public static Double getDouble(Row row, int cell) {
		return row == null ? null : getDouble(row.getCell(cell));
	}

	public static Double getDouble(Cell cell) {
		if (cell == null) { return null; }
		CellType type = cell.getCellType();

		if (type == null) {
			return null;
		} else if (type == CellType.ERROR) {
			return 0D;
		} else if (type == CellType.FORMULA) {
			return Convert.toDouble(cell.getCellFormula(), 0D);
		} else if (type == CellType.STRING) {
			return Convert.toDouble(cell.getStringCellValue(), 0D);
		} else if (type == CellType.BOOLEAN) {
			return Convert.toDouble(cell.getBooleanCellValue(), 0D);
		} else if (type == CellType.NUMERIC) {
			return Convert.toDouble(cell.getNumericCellValue(), 0D);
		} else {
			return null;
		}
	}

	public static Integer getInteger(Sheet sheet, int row, int cell) {
		return sheet == null ? null : getInteger(sheet.getRow(row), cell);
	}

	public static Integer getInteger(Row row, int cell) {
		return row == null ? null : getInteger(row.getCell(cell));
	}

	public static Integer getInteger(Cell cell) {
		if (cell == null) { return null; }
		CellType type = cell.getCellType();

		if (type == null) {
			return null;
		} else if (type == CellType.ERROR) {
			return 0;
		} else if (type == CellType.FORMULA) {
			return Convert.toInt(cell.getCellFormula(), 0);
		} else if (type == CellType.STRING) {
			return Convert.toInt(cell.getStringCellValue(), 0);
		} else if (type == CellType.BOOLEAN) {
			return Convert.toInt(cell.getBooleanCellValue(), 0);
		} else if (type == CellType.NUMERIC) {
			return Convert.toInt(cell.getNumericCellValue(), 0);
		} else {
			return null;
		}
	}

	public static Float getFloat(Sheet sheet, int row, int cell) {
		return sheet == null ? null : getFloat(sheet.getRow(row), cell);
	}

	public static Float getFloat(Row row, int cell) {
		return row == null ? null : getFloat(row.getCell(cell));
	}

	public static Float getFloat(Cell cell) {
		if (cell == null) { return null; }
		CellType type = cell.getCellType();

		if (type == null) {
			return null;
		} else if (type == CellType.ERROR) {
			return 0F;
		} else if (type == CellType.FORMULA) {
			return Convert.toFloat(cell.getCellFormula(), 0F);
		} else if (type == CellType.STRING) {
			return Convert.toFloat(cell.getStringCellValue(), 0F);
		} else if (type == CellType.BOOLEAN) {
			return Convert.toFloat(cell.getBooleanCellValue(), 0F);
		} else if (type == CellType.NUMERIC) {
			return Convert.toFloat(cell.getNumericCellValue(), 0F);
		} else {
			return null;
		}
	}

	public static Boolean getBoolean(Sheet sheet, int row, int cell) {
		return sheet == null ? null : getBoolean(sheet.getRow(row), cell);
	}

	public static Boolean getBoolean(Row row, int cell) {
		return row == null ? null : getBoolean(row.getCell(cell));
	}

	public static Boolean getBoolean(Cell cell) {
		if (cell == null) { return null; }
		CellType type = cell.getCellType();

		if (type == null) {
			return null;
		} else if (type == CellType.ERROR) {
			return false;
		} else if (type == CellType.FORMULA) {
			return Convert.toBool(cell.getCellFormula(), false);
		} else if (type == CellType.STRING) {
			return Convert.toBool(cell.getStringCellValue(), false);
		} else if (type == CellType.BOOLEAN) {
			return Convert.toBool(cell.getBooleanCellValue(), false);
		} else if (type == CellType.NUMERIC) {
			return Convert.toBool(cell.getNumericCellValue(), false);
		} else {
			return null;
		}
	}

	public static Date getDate(Sheet sheet, int row, int cell) {
		return sheet == null ? null : getDate(sheet.getRow(row), cell);
	}

	public static Date getDate(Row row, int cell) {
		return row == null ? null : getDate(row.getCell(cell));
	}

	public static Date getDate(Cell cell) {
		if (cell == null) { return null; }
		CellType type = cell.getCellType();

		if (type == null) {
			return null;
		} else if (type == CellType.NUMERIC) {
			return cell.getDateCellValue();
		} else if (type == CellType.FORMULA) {
			return cell.getDateCellValue();
		} else if (type == CellType.STRING) {
			return parse(cell.getStringCellValue());
		} else {
			return null;
		}
	}

	private static String format(Date date) {
		return DateUtil.format(date, DatePattern.NORM_DATETIME_PATTERN);
	}

	private static Date parse(String date) {
		return DateUtil.parse(date);
	}
}
