package cn.virens.components.poi.common;

import java.util.Calendar;
import java.util.Date;

import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.RichTextString;

public class WriteUtil {
	/**
	 * 设置单元格的值
	 * 
	 * @param  cell  单元格
	 * @param  value value
	 * @return       单元格
	 */
	public static Cell setValue(Cell cell, Object value) {
		if (value == null) {
			cell.setCellType(CellType.BLANK);
		} else if (value instanceof Number) {
			cell.setCellValue(Double.valueOf(((Number) value).doubleValue()));
		} else if (value instanceof Boolean) {
			cell.setCellValue((value != null && (Boolean) value) ? "是" : "否");
		} else if (value instanceof RichTextString) {
			cell.setCellValue((RichTextString) value);
		} else if (value instanceof Calendar) {
			cell.setCellValue((Calendar) value);
		} else if (value instanceof Date) {
			cell.setCellValue((Date) value);
		} else {
			cell.setCellType(CellType.STRING);
			cell.setCellValue(String.valueOf(value));
		}
		return cell;
	}

	/**
	 * 设置单元格的值,并设置单元格样式
	 * 
	 * @param  cell  单元格
	 * @param  style 单元格样式
	 * @param  value value
	 * @return       单元格
	 */
	public static Cell setValue(Cell cell, CellStyle style, Object value) {
		cell.setCellStyle(style);

		return setValue(cell, value);
	}
}
