package cn.virens.components.poi.exception;

import org.apache.poi.ss.usermodel.Cell;

public class CellException extends RowException {
	private static final long serialVersionUID = -4695596792277438038L;

	private int cellIndex;

	public CellException(Cell cell, String message) {
		this(cell.getColumnIndex(), cell.getRowIndex(), message, null);
	}

	public CellException(Cell cell, Throwable cause) {
		this(cell.getColumnIndex(), cell.getRowIndex(), cause.getMessage(), cause);
	}

	public CellException(Cell cell, String message, Throwable cause) {
		this(cell.getColumnIndex(), cell.getRowIndex(), message, cause);
	}

	public CellException(int cellIndex, int rowIndex, String message) {
		this(cellIndex, rowIndex, message, null);
	}

	public CellException(int cellIndex, int rowIndex, String message, Throwable cause) {
		super(rowIndex, message, cause);

		this.cellIndex = cellIndex;
	}

	public int getCellIndex() {
		return cellIndex;
	}

}
