package cn.virens.components.poi.exception;

import org.apache.poi.ss.usermodel.Row;

public class RowException extends Exception {
	private static final long serialVersionUID = -4695596792277438038L;

	private int rowIndex;

	public RowException(Row row, String message) {
		this(row.getRowNum(), message, null);
	}

	public RowException(Row row, Throwable cause) {
		this(row.getRowNum(), cause.getMessage(), cause);
	}

	public RowException(Row row, String message, Throwable cause) {
		this(row.getRowNum(), message, cause);
	}

	public RowException(int rowIndex, String message) {
		this(rowIndex, message, null);
	}

	public RowException(int rowIndex, String message, Throwable cause) {
		super(message, cause);

		this.rowIndex = rowIndex;
	}

	public int getRowIndex() {
		return rowIndex;
	}

}
