package cn.virens.components.poi.read;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

import cn.hutool.core.convert.Convert;

/**
 * 表格行数据封装
 * 
 * @author : virens
 */
public class RowValue implements Serializable {
	private static final long serialVersionUID = -3570953192040750221L;

	private final Map<String, String> cells = new HashMap<>();
	private final Integer index;

	public RowValue(Integer index) {
		this.index = index;
	}

	/**
	 * 获取 行序号
	 * 
	 * @return index
	 */
	public Integer getIndex() {
		return index;
	}

	/**
	 * 获取 全部列
	 * 
	 * @return 列
	 */
	public Map<String, String> getCells() {
		return cells;
	}

	/**
	 * 获取 指定列的值
	 * 
	 * @param  key   列KEY
	 * @param  clazz 值类型
	 * @param        <T> 值类型
	 * @return       返回指定类型的列值
	 */
	public <T> T getCell(String key, Class<T> clazz) {
		return Convert.convert(clazz, cells.get(key));
	}

	/**
	 * 获取 指定列的值(String类型)
	 * 
	 * @param  key 列KEY
	 * @return     返回指定类型的列值
	 */
	public String getCell(Object key) {
		return cells.get(key);
	}

	/**
	 * 将 指定列的值填充到 行中
	 * 
	 * @param  cell  列KEY
	 * @param  value 列值
	 * @return       原列值
	 */
	public String setCell(CellReader cell, Object value) {
		return cells.put(cell.getName(), String.valueOf(value));
	}

	/**
	 * 判断 是否有错误单元格
	 * 
	 * @return 是否有错
	 */
	public boolean isRead() {
		return cells != null && !cells.isEmpty();
	}

}
