package cn.virens.components.poi.write;

import java.io.Serializable;

import org.apache.poi.ss.usermodel.CellStyle;

/**
 * 列模板
 * 
 * @author : virens
 */
public class CellTpl implements Serializable {
	private static final long serialVersionUID = -7535080658344426935L;

	private CellStyle style; // 单元格样式
	private String name; // 表头
	private int index;

	public CellTpl() {
	}

	public CellTpl(String name, int index) {
		this.name = name;
		this.index = index;
	}

	public CellTpl(String name, int index, CellStyle style) {
		this.style = style;
		this.index = index;
		this.name = name;
	}

	/**
	 * 获取 列序号
	 * 
	 * @return index
	 */
	public int getIndex() {
		return index;
	}

	/**
	 * 设置 列序号
	 * 
	 * @param index 列序号
	 */
	public void setIndex(int index) {
		this.index = index;
	}

	/**
	 * 获取 列标题
	 * 
	 * @return name
	 */
	public String getName() {
		return name;
	}

	/**
	 * 设置 列标题
	 * 
	 * @param name 列标题
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * 获取单元格样式
	 * 
	 * @return style
	 */
	public CellStyle getStyle() {
		return style;
	}

	/**
	 * 设置 单元格样式
	 * 
	 * @param style 单元格样式
	 */
	public void setStyle(CellStyle style) {
		this.style = style;
	}
}
