package cn.virens.exception;

/**
 * 自定义数据异常
 * 
 * @author :virens
 */
public class APIException extends RuntimeException implements APIExceptionInter {
	private static final long serialVersionUID = 7595477192082994944L;

	private String code;
	private String message;

	public APIException(Throwable cause) {
		this.setCause(cause);
	}

	public APIException(APIException cause) {
		this.setCode(cause.getCode());
		this.setCause(cause.getCause());
		this.setMessage(cause.getMessage());
	}

	public APIException(int code, String message) {
		this.setCode(code);
		this.setMessage(message);
	}

	public APIException(String code, String message) {
		this.setCode(code);
		this.setMessage(message);
	}

	public APIException(int code, String message, Throwable cause) {
		this.setCode(code);
		this.setCause(cause);
		this.setMessage(message);
	}

	public APIException(String code, String message, Throwable cause) {
		this.setCode(code);
		this.setCause(cause);
		this.setMessage(message);
	}

	public void setCode(String code) {
		this.code = code;
	}

	public void setCode(Integer code) {
		this.code = Integer.toString(code);
	}

	@Override
	public String getCode() {
		return code;
	}

	public void setMessage(String message) {
		this.message = message;
	}

	@Override
	public String getMessage() {
		return (null != message) ? message : super.getMessage();
	}

	private void setCause(Throwable cause) {
		this.initCause(cause);
	}
}
