package cn.virens.exception;

public class ExceptionUtil {

	/**
	 * 根据异常获取对应的异常参数
	 * 
	 * @param  e 异常
	 * @return   Exception's code
	 */
	public static final String getCode(Exception e) {
		if (e instanceof APIExceptionInter) {
			return ((APIExceptionInter) e).getCode();
		} else if (e != null) {
			return e.getClass().getSimpleName();
		} else {
			return "UNKOWN";
		}
	}

	/**
	 * 获取异常提示内容
	 * 
	 * @param  e 异常
	 * @return   Exception's message
	 */
	public static final String getMessage(Exception e) {
		if (e != null) {
			return e.getMessage();
		} else {
			return "未知错误";
		}
	}
}
