package cn.wangdm.sms.entity;

import java.sql.Timestamp;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;

import lombok.Data;

@Data
@Entity
@Table(name="SmsMessage")
public class SmsMessage {
	
	public enum SmsStatus{
		INIT(0), SUCCESS(1), FAILED(2);
		
		private int value;
		
		SmsStatus(int val) {
			value = val;
		}

		public int toInt() {
			return value;
		}
	}
	
	@Id
	@GeneratedValue(strategy=GenerationType.IDENTITY)
	private Long id;

	@Column(name = "target")
	private String target;

	@Column(name = "template")
	private String template;

	@Column(name = "content")
	private String content;

	@Column(name = "parameter")
	private String parameter;

	@Column(name = "status")
	private Integer status;

	@Column(name = "error")
	private String error;

	@Column(name="create_time", updatable=false)
	private Timestamp createTime;

	@Column(name="update_time")
	private Timestamp updateTime;

}
