package cn.wangdm.sms.queue;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

import cn.wangdm.sms.SmsSender;
import cn.wangdm.sms.entity.SmsMessage;

@Component
@ConditionalOnProperty(name="spring.sms.type", havingValue="queue", matchIfMissing=true)
public class QueueSmsSender implements SmsSender {
	
	private Queue<Object> queue;

	@Bean("customSmsQueue")
	Queue<Object> smsQueue(){
		queue = new ConcurrentLinkedQueue<Object>();
		return queue;
	}
	
	@Override
	public void send(SmsMessage message) {
		queue.add(message);
	}

}
