package cn.wangdm.sms.queue;

import java.util.Queue;
import java.util.concurrent.ExecutorService;

import javax.annotation.Resource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import cn.wangdm.sms.entity.SmsMessage;
import cn.wangdm.sms.service.SmsService;
import lombok.extern.slf4j.Slf4j;

@Slf4j
@EnableScheduling
@Component
@ConditionalOnProperty(name="spring.sms.type", havingValue="queue", matchIfMissing=true)
public class SmsQueueListener {
	
	@Resource(name="customSmsQueue")  
	private Queue<Object> queue;
	
	@Autowired
	private SmsService smsService;

	@Autowired
	@Qualifier("smsExecutorPool")
	private ExecutorService executorService;
	
	@Scheduled(fixedRate=2000)
	private void checkQueue() {
		log.trace("Check sms queue, count:{}", queue.size());
		if(queue.size() > 0) {
			do {
				SmsMessage message = (SmsMessage) queue.poll();
				if(message == null) {
					break;
				}
				executorService.submit(new Runnable() {
					@Override
					public void run() {
						smsService.sendSms(message);
					}
				});
			}while(true);
		}
	}

}
