package cn.wangdm.sms.service.impl;

import java.sql.Timestamp;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.aliyuncs.CommonRequest;
import com.aliyuncs.CommonResponse;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.profile.DefaultProfile;

import cn.wangdm.sms.config.SmsConfig;
import cn.wangdm.sms.dao.SmsMessageDao;
import cn.wangdm.sms.entity.SmsMessage;
import cn.wangdm.sms.service.SmsService;
import lombok.extern.slf4j.Slf4j;

@Slf4j
@Component
public class SmsServiceImpl implements SmsService {
	
	@Autowired
	private SmsConfig config;
	
	@Autowired
	private SmsMessageDao smsDao;
	
	@Override
	public void sendSms(SmsMessage message) {

        DefaultProfile profile = DefaultProfile.getProfile(config.getRegion(), config.getAccessKeyId(), config.getAccessSecret());
        IAcsClient client = new DefaultAcsClient(profile);

        CommonRequest request = new CommonRequest();
        //request.setProtocol(ProtocolType.HTTPS);
        request.setMethod(MethodType.POST);
        request.setDomain(config.getDomain());
        request.setVersion(config.getVersion());
        request.setAction("SendSms");
        request.putQueryParameter("PhoneNumbers", message.getTarget());
        request.putQueryParameter("SignName", config.getSign());
        request.putQueryParameter("TemplateCode", message.getTemplate());
        request.putQueryParameter("TemplateParam", message.getParameter());
        //request.putQueryParameter("SmsUpExtendCode", "222");
        //request.putQueryParameter("OutId", "333");
        try {
            CommonResponse response = client.getCommonResponse(request);
            message.setStatus(SmsMessage.SmsStatus.SUCCESS.toInt());
            message.setContent(response.getData());
        } catch (Exception e) {
            message.setStatus(SmsMessage.SmsStatus.FAILED.toInt());
            message.setError(e.getMessage());
        	log.error("Send sms failed, exception:{}, target:{}, template:{} ", e.getMessage(), message.getTarget(), message.getTemplate());
        }
        message.setCreateTime(new Timestamp(System.currentTimeMillis()));
        message.setUpdateTime(message.getCreateTime());
		smsDao.saveAndFlush(message);
	}

}
