/*
 * Decompiled with CFR 0.152.
 */
package cn.wangdm.sms.executor;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class SmsExecutor {
    @Value(value="${spring.sms.executor.min-count:0}")
    private int minThreadCount = 0;
    @Value(value="${spring.sms.executor.max-count:4}")
    private int maxThreadCount = 4;
    @Value(value="${spring.sms.executor.idle-time:60}")
    private long threadIdleTime = 60L;

    @Bean(value={"smsExecutorPool"})
    public ExecutorService smsExecutor() {
        return new ThreadPoolExecutor(this.minThreadCount, this.maxThreadCount, this.threadIdleTime, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
    }
}

