/*
 * Decompiled with CFR 0.152.
 */
package cn.wangdm.sms.queue;

import cn.wangdm.sms.SmsSender;
import cn.wangdm.sms.entity.SmsMessage;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(name={"spring.sms.type"}, havingValue="queue", matchIfMissing=true)
public class QueueSmsSender
implements SmsSender {
    private Queue<Object> queue;

    @Bean(value={"customSmsQueue"})
    Queue<Object> smsQueue() {
        this.queue = new ConcurrentLinkedQueue<Object>();
        return this.queue;
    }

    @Override
    public void send(SmsMessage message) {
        this.queue.add(message);
    }
}

