/*
 * Decompiled with CFR 0.152.
 */
package cn.wangdm.sms.queue;

import cn.wangdm.sms.entity.SmsMessage;
import cn.wangdm.sms.service.SmsService;
import java.util.Queue;
import java.util.concurrent.ExecutorService;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@EnableScheduling
@Component
@ConditionalOnProperty(name={"spring.sms.type"}, havingValue="queue", matchIfMissing=true)
public class SmsQueueListener {
    private static final Logger log = LoggerFactory.getLogger(SmsQueueListener.class);
    @Resource(name="customSmsQueue")
    private Queue<Object> queue;
    @Autowired
    private SmsService smsService;
    @Autowired
    @Qualifier(value="smsExecutorPool")
    private ExecutorService executorService;

    @Scheduled(fixedRate=2000L)
    private void checkQueue() {
        log.trace("Check sms queue, count:{}", (Object)this.queue.size());
        if (this.queue.size() > 0) {
            SmsMessage message;
            while ((message = (SmsMessage)this.queue.poll()) != null) {
                this.executorService.submit(new Runnable(){

                    @Override
                    public void run() {
                        SmsQueueListener.this.smsService.sendSms(message);
                    }
                });
            }
        }
    }
}

