/*
 * Decompiled with CFR 0.152.
 */
package cn.wangdm.sms.service.impl;

import cn.wangdm.sms.config.SmsConfig;
import cn.wangdm.sms.dao.SmsMessageDao;
import cn.wangdm.sms.entity.SmsMessage;
import cn.wangdm.sms.service.SmsService;
import com.aliyuncs.CommonRequest;
import com.aliyuncs.CommonResponse;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import java.sql.Timestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SmsServiceImpl
implements SmsService {
    private static final Logger log = LoggerFactory.getLogger(SmsServiceImpl.class);
    @Autowired
    private SmsConfig config;
    @Autowired
    private SmsMessageDao smsDao;

    @Override
    public void sendSms(SmsMessage message) {
        DefaultProfile profile = DefaultProfile.getProfile((String)this.config.getRegion(), (String)this.config.getAccessKeyId(), (String)this.config.getAccessSecret());
        DefaultAcsClient client = new DefaultAcsClient((IClientProfile)profile);
        CommonRequest request = new CommonRequest();
        request.setMethod(MethodType.POST);
        request.setDomain(this.config.getDomain());
        request.setVersion(this.config.getVersion());
        request.setAction("SendSms");
        request.putQueryParameter("PhoneNumbers", message.getTarget());
        request.putQueryParameter("SignName", this.config.getSign());
        request.putQueryParameter("TemplateCode", message.getTemplate());
        request.putQueryParameter("TemplateParam", message.getParameter());
        try {
            CommonResponse response = client.getCommonResponse(request);
            message.setStatus(SmsMessage.SmsStatus.SUCCESS.toInt());
            message.setContent(response.getData());
        }
        catch (Exception e) {
            message.setStatus(SmsMessage.SmsStatus.FAILED.toInt());
            message.setError(e.getMessage());
            log.error("Send sms failed, exception:{}, target:{}, template:{} ", new Object[]{e.getMessage(), message.getTarget(), message.getTemplate()});
        }
        message.setCreateTime(new Timestamp(System.currentTimeMillis()));
        message.setUpdateTime(message.getCreateTime());
        this.smsDao.saveAndFlush(message);
    }
}

