/*
 * Decompiled with CFR 0.152.
 */
package cn.wizzer.iot.mqtt.server.store.cache;

import cn.wizzer.iot.mqtt.server.common.message.RetainMessageStore;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import org.nutz.aop.interceptor.async.Async;
import org.nutz.integration.jedis.RedisService;
import org.nutz.ioc.impl.PropertiesProxy;
import org.nutz.ioc.loader.annotation.Inject;
import org.nutz.ioc.loader.annotation.IocBean;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;

@IocBean
public class RetainMessageCache {
    private static final String CACHE_PRE = "mqttwk:retain:";
    @Inject
    private RedisService redisService;
    @Inject
    private PropertiesProxy conf;

    public RetainMessageStore put(String topic, RetainMessageStore obj) {
        this.redisService.set(CACHE_PRE + topic, JSONObject.toJSONString((Object)obj));
        return obj;
    }

    public RetainMessageStore get(String topic) {
        return (RetainMessageStore)JSONObject.parseObject((String)this.redisService.get(CACHE_PRE + topic), RetainMessageStore.class);
    }

    public boolean containsKey(String topic) {
        return this.redisService.exists(CACHE_PRE + topic);
    }

    @Async
    public void remove(String topic) {
        this.redisService.del(CACHE_PRE + topic);
    }

    public Map<String, RetainMessageStore> all() {
        HashMap<String, RetainMessageStore> map = new HashMap<String, RetainMessageStore>();
        ScanParams match = new ScanParams().match("mqttwk:retain:*");
        ScanResult scan = null;
        do {
            scan = this.redisService.scan(scan == null ? ScanParams.SCAN_POINTER_START : scan.getStringCursor(), match);
            for (String key : scan.getResult()) {
                map.put(key.substring(CACHE_PRE.length()), (RetainMessageStore)JSONObject.parseObject((String)this.redisService.get(key), RetainMessageStore.class));
            }
        } while (!scan.isCompleteIteration());
        return map;
    }
}

