/*
 * Decompiled with CFR 0.152.
 */
package cn.wizzer.iot.mqtt.server.store.cache;

import cn.wizzer.iot.mqtt.server.common.subscribe.SubscribeStore;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.nutz.aop.interceptor.async.Async;
import org.nutz.integration.jedis.RedisService;
import org.nutz.ioc.loader.annotation.Inject;
import org.nutz.ioc.loader.annotation.IocBean;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;

@IocBean
public class SubscribeWildcardCache {
    private static final String CACHE_PRE = "mqttwk:subwildcard:";
    private static final String CACHE_CLIENT_PRE = "mqttwk:client:";
    @Inject
    private RedisService redisService;

    public SubscribeStore put(String topic, String clientId, SubscribeStore subscribeStore) {
        this.redisService.hset(CACHE_PRE + topic, clientId, JSONObject.toJSONString((Object)subscribeStore));
        this.redisService.sadd(CACHE_CLIENT_PRE + clientId, new String[]{topic});
        return subscribeStore;
    }

    public SubscribeStore get(String topic, String clientId) {
        return (SubscribeStore)JSONObject.parseObject((String)this.redisService.hget(CACHE_PRE + topic, clientId), SubscribeStore.class);
    }

    public boolean containsKey(String topic, String clientId) {
        return this.redisService.hexists(CACHE_PRE + topic, clientId);
    }

    @Async
    public void remove(String topic, String clientId) {
        this.redisService.srem(CACHE_CLIENT_PRE + clientId, new String[]{topic});
        this.redisService.hdel(CACHE_PRE + topic, new String[]{clientId});
    }

    @Async
    public void removeForClient(String clientId) {
        for (String topic : this.redisService.smembers(CACHE_CLIENT_PRE + clientId)) {
            this.redisService.hdel(CACHE_PRE + topic, new String[]{clientId});
        }
        this.redisService.del(CACHE_CLIENT_PRE + clientId);
    }

    public Map<String, ConcurrentHashMap<String, SubscribeStore>> all() {
        HashMap<String, ConcurrentHashMap<String, SubscribeStore>> map = new HashMap<String, ConcurrentHashMap<String, SubscribeStore>>();
        ScanParams match = new ScanParams().match("mqttwk:subwildcard:*");
        ScanResult scan = null;
        do {
            scan = this.redisService.scan(scan == null ? ScanParams.SCAN_POINTER_START : scan.getStringCursor(), match);
            for (String key : scan.getResult()) {
                ConcurrentHashMap map1 = new ConcurrentHashMap();
                Map map2 = this.redisService.hgetAll(key);
                if (map2 == null || map2.isEmpty()) continue;
                map2.forEach((k, v) -> map1.put(k, JSONObject.parseObject((String)v, SubscribeStore.class)));
                map.put(key.substring(CACHE_PRE.length()), map1);
            }
        } while (!scan.isCompleteIteration());
        return map;
    }

    public List<SubscribeStore> all(String topic) {
        ArrayList<SubscribeStore> list = new ArrayList<SubscribeStore>();
        Map map = this.redisService.hgetAll(CACHE_PRE + topic);
        if (map != null && !map.isEmpty()) {
            map.forEach((k, v) -> list.add((SubscribeStore)JSONObject.parseObject((String)v, SubscribeStore.class)));
        }
        return list;
    }
}

