/*
 * Decompiled with CFR 0.152.
 */
package cn.wizzer.iot.mqtt.server.store.message;

import cn.hutool.core.util.StrUtil;
import cn.wizzer.iot.mqtt.server.common.message.IRetainMessageStoreService;
import cn.wizzer.iot.mqtt.server.common.message.RetainMessageStore;
import cn.wizzer.iot.mqtt.server.store.cache.RetainMessageCache;
import java.util.ArrayList;
import java.util.List;
import org.nutz.ioc.loader.annotation.Inject;
import org.nutz.ioc.loader.annotation.IocBean;

@IocBean
public class RetainMessageStoreService
implements IRetainMessageStoreService {
    @Inject
    private RetainMessageCache retainMessageCache;

    public void put(String topic, RetainMessageStore retainMessageStore) {
        this.retainMessageCache.put(topic, retainMessageStore);
    }

    public RetainMessageStore get(String topic) {
        return this.retainMessageCache.get(topic);
    }

    public void remove(String topic) {
        this.retainMessageCache.remove(topic);
    }

    public boolean containsKey(String topic) {
        return this.retainMessageCache.containsKey(topic);
    }

    public List<RetainMessageStore> search(String topicFilter) {
        ArrayList<RetainMessageStore> retainMessageStores = new ArrayList<RetainMessageStore>();
        if (!StrUtil.contains((CharSequence)topicFilter, (char)'#') && !StrUtil.contains((CharSequence)topicFilter, (char)'+')) {
            if (this.retainMessageCache.containsKey(topicFilter)) {
                retainMessageStores.add(this.retainMessageCache.get(topicFilter));
            }
        } else {
            this.retainMessageCache.all().forEach((topic, val) -> {
                if (StrUtil.split((CharSequence)topic, (char)'/').size() >= StrUtil.split((CharSequence)topicFilter, (char)'/').size()) {
                    List splitTopics = StrUtil.split((CharSequence)topic, (char)'/');
                    List spliteTopicFilters = StrUtil.split((CharSequence)topicFilter, (char)'/');
                    String newTopicFilter = "";
                    for (int i = 0; i < spliteTopicFilters.size(); ++i) {
                        String value = (String)spliteTopicFilters.get(i);
                        if (value.equals("+")) {
                            newTopicFilter = newTopicFilter + "+/";
                            continue;
                        }
                        if (value.equals("#")) {
                            newTopicFilter = newTopicFilter + "#/";
                            break;
                        }
                        newTopicFilter = newTopicFilter + (String)splitTopics.get(i) + "/";
                    }
                    if (topicFilter.equals(newTopicFilter = StrUtil.removeSuffix((CharSequence)newTopicFilter, (CharSequence)"/"))) {
                        retainMessageStores.add((RetainMessageStore)val);
                    }
                }
            });
        }
        return retainMessageStores;
    }
}

