/*
 * Decompiled with CFR 0.152.
 */
package cn.wizzer.iot.mqtt.server.store.session;

import cn.wizzer.iot.mqtt.server.common.session.ISessionStoreService;
import cn.wizzer.iot.mqtt.server.common.session.SessionStore;
import cn.wizzer.iot.mqtt.server.store.util.StoreUtil;
import com.alibaba.fastjson.JSON;
import org.nutz.aop.interceptor.async.Async;
import org.nutz.integration.jedis.RedisService;
import org.nutz.ioc.loader.annotation.Inject;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.lang.Strings;
import org.nutz.lang.util.NutMap;

@IocBean
public class SessionStoreService
implements ISessionStoreService {
    private static final String CACHE_PRE = "mqttwk:session:";
    @Inject
    private RedisService redisService;

    public void put(String clientId, SessionStore sessionStore, int expire) {
        NutMap nutMap = StoreUtil.transPublishToMapBeta(sessionStore);
        if (nutMap != null) {
            if (expire > 0) {
                this.redisService.setex(CACHE_PRE + clientId, expire, JSON.toJSONString((Object)nutMap));
            } else {
                this.redisService.set(CACHE_PRE + clientId, JSON.toJSONString((Object)nutMap));
            }
        }
    }

    public void expire(String clientId, int expire) {
        this.redisService.expire(CACHE_PRE + clientId, expire);
    }

    public SessionStore get(String clientId) {
        String jsonObj = this.redisService.get(CACHE_PRE + clientId);
        if (Strings.isNotBlank((CharSequence)jsonObj)) {
            NutMap nutMap = (NutMap)JSON.parseObject((String)jsonObj, NutMap.class);
            return StoreUtil.mapTransToPublishMsgBeta(nutMap);
        }
        return null;
    }

    public boolean containsKey(String clientId) {
        return this.redisService.exists(CACHE_PRE + clientId);
    }

    @Async
    public void remove(String clientId) {
        this.redisService.del(CACHE_PRE + clientId);
    }
}

