/*
 * Decompiled with CFR 0.152.
 */
package cn.wizzer.iot.mqtt.server.store.starter;

import java.util.Properties;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.nutz.boot.annotation.PropDoc;
import org.nutz.ioc.impl.PropertiesProxy;
import org.nutz.ioc.loader.annotation.Inject;
import org.nutz.ioc.loader.annotation.IocBean;

@IocBean(create="init", depose="close")
public class StoreStarter {
    @Inject
    protected PropertiesProxy conf;
    protected KafkaProducer kafkaProducer;
    protected static final String PRE = "mqttwk.broker.";
    @PropDoc(group="broker", value="\u5b9e\u4f8b\u540d\u79f0", need=true, defaultValue="mqttwk")
    public static final String PROP_INSTANCENAME = "mqttwk.broker.id";
    @PropDoc(group="broker", value="\u662f\u5426\u542f\u7528kafka\u6d88\u606f\u8f6c\u53d1", need=true, defaultValue="false")
    public static final String PROP_KAFKA_BROKER_ENABLED = "mqttwk.broker.kafka.broker-enabled";
    @PropDoc(group="broker", value="kafka\u5730\u5740 127.0.0.1:9092,127.0.0.1:9093", need=true, defaultValue="127.0.0.1:9092")
    public static final String PROP_KAFKA_SERVERS = "mqttwk.broker.kafka.bootstrap.servers";
    @PropDoc(group="broker", value="all:\u5fc5\u987b\u7b49\u5f85\u56de\u4ee4 -1:\u4e0d\u7b49\u5f85", defaultValue="all")
    public static final String PROP_KAFKA_ACKS = "mqttwk.broker.kafka.acks";
    @PropDoc(group="broker", value="\u91cd\u8bd5\u6b21\u6570", type="int", defaultValue="0")
    public static final String PROP_KAFKA_RETRIES = "mqttwk.broker.kafka.retries";
    @PropDoc(group="broker", value="\u6279\u91cf\u63d0\u4ea4\u5927\u5c0f", type="int", defaultValue="16384")
    public static final String PROP_KAFKA_BATCHSIZE = "mqttwk.broker.kafka.batch.size";
    @PropDoc(group="broker", value="\u63d0\u4ea4\u5ef6\u8fdf\u7b49\u5f85\u65f6\u95f4(\u7b49\u5f85\u65f6\u95f4\u5185\u53ef\u4ee5\u8ffd\u52a0\u63d0\u4ea4)", type="int", defaultValue="1")
    public static final String PROP_KAFKA_LINGERMS = "mqttwk.broker.kafka.linger.ms";
    @PropDoc(group="broker", value="\u7f13\u5b58\u5927\u5c0f(Bit) \u9ed8\u8ba4:64MB", type="int", defaultValue="67108864")
    public static final String PROP_KAFKA_BUFFERMEMORY = "mqttwk.broker.kafka.buffer.memory";
    @PropDoc(group="broker", value="key\u5e8f\u5217\u5316\u65b9\u6cd5", defaultValue="org.apache.kafka.common.serialization.StringSerializer")
    public static final String PROP_KAFKA_KEYSERIALIZER = "mqttwk.broker.kafka.key.serializer";
    @PropDoc(group="broker", value="value\u5e8f\u5217\u5316\u65b9\u6cd5", defaultValue="org.apache.kafka.common.serialization.StringSerializer")
    public static final String PROP_KAFKA_VALUESERIALIZER = "mqttwk.broker.kafka.value.serializer";
    @PropDoc(group="broker", value="\u5206\u53d1\u7b56\u7565", defaultValue="cn.wizzer.iot.mqtt.server.store.kafka.SimplePartitioner")
    public static final String PROP_KAFKA_PARTITIONERCLASS = "mqttwk.broker.kafka.partitioner.class";

    public Properties getProperties() {
        Properties properties = new Properties();
        for (String key : this.conf.keySet()) {
            if (!key.startsWith("mqttwk.broker.kafka.")) continue;
            properties.put(key.substring("mqttwk.broker.kafka.".length()), this.conf.get(key));
        }
        return properties;
    }

    @IocBean
    public KafkaProducer kafkaProducer() {
        return this.kafkaProducer;
    }

    public void init() throws Exception {
        if (this.conf.getBoolean(PROP_KAFKA_BROKER_ENABLED, false)) {
            this.kafkaProducer = new KafkaProducer(this.getProperties());
        }
    }

    public void close() throws Exception {
        if (this.kafkaProducer != null) {
            this.kafkaProducer.close();
        }
    }
}

