/*
 * Decompiled with CFR 0.152.
 */
package cn.xfyun.model.sign;

import cn.xfyun.util.CryptTools;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.digest.DigestUtils;

public class Signature {
    public static String signHostDateAuthorization(String requestUrl, String requestMethod, String apiKey, String apiSecret) {
        URL url = null;
        String httpRequestUrl = requestUrl.replace("ws://", "http://").replace("wss://", "https://");
        try {
            url = new URL(httpRequestUrl);
            SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
            format.setTimeZone(TimeZone.getTimeZone("UTC"));
            String date = format.format(new Date());
            String host = url.getHost();
            StringBuilder builder = new StringBuilder().append("host: ").append(host).append("\n").append("date: ").append(date).append("\n").append(requestMethod).append(" ").append(url.getPath()).append(" HTTP/1.1");
            Charset charset = StandardCharsets.UTF_8;
            SecretKeySpec spec = new SecretKeySpec(apiSecret.getBytes(charset), "hmacsha256");
            Mac mac = Mac.getInstance("hmacsha256");
            mac.init(spec);
            byte[] hexDigits = mac.doFinal(builder.toString().getBytes(charset));
            String sha = Base64.getEncoder().encodeToString(hexDigits);
            String authorization = String.format("api_key=\"%s\", algorithm=\"%s\", headers=\"%s\", signature=\"%s\"", apiKey, "hmac-sha256", "host date request-line", sha);
            String authBase = Base64.getEncoder().encodeToString(authorization.getBytes(charset));
            return String.format("%s?authorization=%s&host=%s&date=%s", requestUrl, URLEncoder.encode(authBase), URLEncoder.encode(host), URLEncoder.encode(date));
        }
        catch (Exception e) {
            throw new RuntimeException("assemble requestUrl error:" + e.getMessage());
        }
    }

    public static Map<String, String> signHttpHeaderDigest(String requestUrl, String requestMethod, String apiKey, String apiSecret, String body) throws Exception {
        HashMap<String, String> header = new HashMap<String, String>(6);
        URL url = new URL(requestUrl);
        SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
        format.setTimeZone(TimeZone.getTimeZone("GMT"));
        String date = format.format(new Date());
        String digestBase64 = "SHA-256=" + Signature.signBody(body);
        StringBuilder builder = new StringBuilder("host: ").append(url.getHost()).append("\n").append("date: ").append(date).append("\n").append(requestMethod + " ").append(url.getPath()).append(" HTTP/1.1").append("\n").append("digest: ").append(digestBase64);
        String sha = Signature.hmacsign(builder.toString(), apiSecret);
        String authorization = String.format("api_key=\"%s\", algorithm=\"%s\", headers=\"%s\", signature=\"%s\"", apiKey, "hmac-sha256", "host date request-line digest", sha);
        header.put("Authorization", authorization);
        header.put("Content-Type", "application/json");
        header.put("Accept", "application/json,version=1.0");
        header.put("Host", url.getHost());
        header.put("Date", date);
        header.put("Digest", digestBase64);
        return header;
    }

    private static String signBody(String body) {
        String encodestr = "";
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(body.getBytes("UTF-8"));
            encodestr = Base64.getEncoder().encodeToString(messageDigest.digest());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return encodestr;
    }

    private static String hmacsign(String signature, String apiSecret) throws Exception {
        Charset charset = Charset.forName("UTF-8");
        Mac mac = Mac.getInstance("hmacsha256");
        SecretKeySpec spec = new SecretKeySpec(apiSecret.getBytes(charset), "hmacsha256");
        mac.init(spec);
        byte[] hexDigits = mac.doFinal(signature.getBytes(charset));
        return Base64.getEncoder().encodeToString(hexDigits);
    }

    public static Map<String, String> signHttpHeaderCheckSum(String appId, String apiKey, String param) throws UnsupportedEncodingException {
        String curTime = String.valueOf(System.currentTimeMillis() / 1000L);
        String paramBase64 = Base64.getEncoder().encodeToString(param.getBytes("UTF-8"));
        String checkSum = DigestUtils.md5Hex((String)(apiKey + curTime + paramBase64));
        HashMap<String, String> header = new HashMap<String, String>(6);
        header.put("X-Param", paramBase64);
        header.put("X-CurTime", curTime);
        header.put("X-CheckSum", checkSum);
        header.put("X-Appid", appId);
        return header;
    }

    public static String rtasrSignature(String url, String appId, String key) {
        url = url.replace("ws://", "http://").replace("wss://", "https://");
        String ts = String.valueOf(System.currentTimeMillis() / 1000L);
        try {
            String signature = CryptTools.hmacEncrypt("HmacSHA1", CryptTools.md5Encrypt(appId + ts), key);
            return url + "?appid=" + appId + "&ts=" + ts + "&signa=" + URLEncoder.encode(signature, "UTF-8");
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }
}

