/*
 * Decompiled with CFR 0.152.
 */
package cn.xfyun.util;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.net.ssl.SSLException;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ByteArrayBody;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpConnector {
    private static final Logger log = LoggerFactory.getLogger(HttpConnector.class);
    private final PoolingHttpClientConnectionManager pool = new PoolingHttpClientConnectionManager();
    private CloseableHttpClient httpClient;

    private HttpConnector() {
    }

    public static HttpConnector build(int maxConnections, int connTimeout, int soTimeout, int retryCount) {
        HttpConnector connector = ConnectorBuilder.CONNECTOR;
        connector.pool.setMaxTotal(maxConnections);
        connector.pool.setDefaultMaxPerRoute(5);
        RequestConfig.Builder builder = RequestConfig.custom().setConnectionRequestTimeout(5000).setConnectTimeout(connTimeout).setSocketTimeout(soTimeout);
        HttpClientBuilder httpClientBuilder = HttpClients.custom().setDefaultRequestConfig(builder.build()).setConnectionManager((HttpClientConnectionManager)connector.pool);
        if (retryCount > 0) {
            HttpRequestRetryHandler retryHandler = (exception, executionCount, context) -> {
                if (executionCount > retryCount) {
                    return false;
                }
                if (exception instanceof InterruptedIOException) {
                    return false;
                }
                if (exception instanceof UnknownHostException) {
                    return false;
                }
                if (exception instanceof SSLException) {
                    return false;
                }
                log.info("HttpConnector \u7b2c" + executionCount + "\u6b21\u91cd\u8bd5");
                return true;
            };
            httpClientBuilder.setRetryHandler(retryHandler);
        }
        connector.httpClient = httpClientBuilder.build();
        return connector;
    }

    private static List<NameValuePair> convertMapToPair(Map<String, String> params) {
        ArrayList<NameValuePair> pairs = new ArrayList<NameValuePair>();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            pairs.add((NameValuePair)new BasicNameValuePair(entry.getKey(), entry.getValue()));
        }
        return pairs;
    }

    public String post(String url, Map<String, String> param) throws IOException {
        HttpPost httpPost = new HttpPost(url);
        httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(HttpConnector.convertMapToPair(param), Consts.UTF_8));
        return this.doExecute((HttpRequestBase)httpPost, Consts.UTF_8.toString());
    }

    public String postByJson(String url, String jsonStr) throws IOException {
        HttpPost httpPost = new HttpPost(url);
        httpPost.setHeader("Content-Type", "application/json;charset=UTF-8");
        httpPost.setEntity((HttpEntity)new StringEntity(jsonStr, Consts.UTF_8));
        return this.doExecute((HttpRequestBase)httpPost, Consts.UTF_8.toString());
    }

    public String postByBytes(String url, Map<String, String> param, byte[] bytes) throws IOException {
        HttpPost httpPost = new HttpPost(url);
        for (String key : param.keySet()) {
            httpPost.setHeader(key, param.get(key));
        }
        if (Objects.nonNull(bytes)) {
            httpPost.setEntity((HttpEntity)new ByteArrayEntity(bytes));
        }
        return this.doExecute((HttpRequestBase)httpPost, Consts.UTF_8.toString());
    }

    public String post(String url, Map<String, String> header, Map<String, String> param) throws IOException {
        HttpPost httpPost = new HttpPost(url);
        Set<String> keys = header.keySet();
        for (String key : keys) {
            httpPost.setHeader(key, header.get(key));
        }
        httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(HttpConnector.convertMapToPair(param), Consts.UTF_8));
        return this.doExecute((HttpRequestBase)httpPost, Consts.UTF_8.toString());
    }

    public String post(String url, String param) throws IOException {
        HttpPost httpPost = new HttpPost(url);
        httpPost.addHeader("Content-Type", "application/json;charset=utf-8");
        StringEntity httpEntity = new StringEntity(param, ContentType.APPLICATION_JSON);
        httpPost.setEntity((HttpEntity)httpEntity);
        return this.doExecute((HttpRequestBase)httpPost, Consts.UTF_8.toString());
    }

    public String post(String url, Map<String, String> param, byte[] body) throws IOException {
        HttpPost httpPost = new HttpPost(url);
        MultipartEntityBuilder reqEntity = MultipartEntityBuilder.create();
        reqEntity.addPart("content", (ContentBody)new ByteArrayBody(body, ContentType.DEFAULT_BINARY, param.get("slice_id")));
        for (Map.Entry<String, String> entry : param.entrySet()) {
            StringBody value = new StringBody(entry.getValue(), ContentType.create((String)"text/plain", (Charset)Consts.UTF_8));
            reqEntity.addPart(entry.getKey(), (ContentBody)value);
        }
        HttpEntity httpEntry = reqEntity.build();
        httpPost.setEntity(httpEntry);
        return this.doExecute((HttpRequestBase)httpPost, Consts.UTF_8.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String doExecute(HttpRequestBase requestBase, String charset) throws IOException {
        String result;
        CloseableHttpResponse response = null;
        try {
            response = this.httpClient.execute((HttpUriRequest)requestBase);
            int statusCode = response.getStatusLine().getStatusCode();
            String string = result = charset == null ? EntityUtils.toString((HttpEntity)response.getEntity()) : EntityUtils.toString((HttpEntity)response.getEntity(), (String)charset);
            if (statusCode != 200) {
                log.warn("request:{} , status:{} , result:{}", new Object[]{requestBase.getURI(), statusCode, result});
            }
        }
        finally {
            if (null != response) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            }
            if (null != requestBase) {
                requestBase.releaseConnection();
            }
        }
        return result;
    }

    public void release() {
        try {
            this.httpClient.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static class ConnectorBuilder {
        private static final HttpConnector CONNECTOR = new HttpConnector();

        private ConnectorBuilder() {
        }
    }
}

