/*
 * Decompiled with CFR 0.152.
 */
package cn.xfyun.api;

import cn.xfyun.exception.LfasrException;
import cn.xfyun.model.response.lfasr.LfasrMessage;
import cn.xfyun.model.sign.LfasrSignature;
import cn.xfyun.service.lfasr.LfasrExecutorService;
import cn.xfyun.service.lfasr.task.MergeTask;
import cn.xfyun.service.lfasr.task.PrepareTask;
import cn.xfyun.service.lfasr.task.PullResultTask;
import cn.xfyun.service.lfasr.task.QueryProgressTask;
import cn.xfyun.service.lfasr.task.UploadTask;
import cn.xfyun.util.SliceIdGenerator;
import cn.xfyun.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.security.SignatureException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LfasrClient {
    private static final Logger logger = LoggerFactory.getLogger(LfasrClient.class);
    private static final int FILE_UPLOAD_MAXSIZE = 524288000;
    private static int SLICE_SIZE = 0xA00000;
    private final String secretKey;
    private volatile LfasrExecutorService lfasrExecutorService;
    private String appId;
    private String file_name;
    private Integer slice_size;
    private Integer slice_num;
    private String lfasr_type;
    private String has_participle;
    private String max_alternatives;
    private String speaker_number;
    private String has_seperate;
    private String role_type;
    private String language;
    private String pd;

    public LfasrClient(Builder builder) {
        this.appId = builder.appId;
        this.secretKey = builder.secretKey;
        this.file_name = builder.file_name;
        this.slice_size = builder.slice_size;
        this.lfasr_type = builder.lfasr_type;
        this.has_participle = builder.has_participle;
        this.max_alternatives = builder.max_alternatives;
        this.speaker_number = builder.speaker_number;
        this.has_seperate = builder.has_seperate;
        this.role_type = builder.role_type;
        this.language = builder.language;
        this.pd = builder.pd;
    }

    public LfasrMessage prepare(String audioFilePath) throws LfasrException, SignatureException {
        if (StringUtils.isNullOrEmpty((String)audioFilePath)) {
            throw new LfasrException("audioFilePath is null!");
        }
        File audio = new File(audioFilePath);
        if (!audio.exists()) {
            throw new LfasrException(audioFilePath + " is not exists!");
        }
        long length = audio.length();
        if (length > 524288000L) {
            throw new LfasrException(audioFilePath + " is too large! (500M)");
        }
        HashMap<String, String> param = new HashMap<String, String>(32);
        this.paramHandler(param, length, audio);
        return this.lfasrExecutorService.exec(new PrepareTask(new LfasrSignature(this.appId, this.secretKey), param));
    }

    public void uploadFile(String taskId, String audioFilePath) throws LfasrException {
        File audio = new File(audioFilePath);
        try (FileInputStream fis = new FileInputStream(audio);){
            int len;
            byte[] slice = new byte[SLICE_SIZE];
            SliceIdGenerator generator = new SliceIdGenerator();
            while ((len = fis.read(slice)) > 0) {
                byte[] data = Arrays.copyOfRange(slice, 0, len);
                UploadTask uploadTask = new UploadTask(new LfasrSignature(this.appId, this.secretKey), taskId, generator.getNextSliceId(), data);
                this.lfasrExecutorService.exec(uploadTask);
            }
        }
        catch (Exception e) {
            logger.error(audioFilePath + "\u4e0a\u4f20\u5904\u7406\u5931\u8d25", (Throwable)e);
            throw new LfasrException("\u8f6c\u5199\u4e0a\u4f20\u6587\u4ef6\u8bfb\u53d6\u9519\u8bef");
        }
    }

    public LfasrMessage mergeFile(String taskId) throws LfasrException, SignatureException {
        return this.lfasrExecutorService.exec(new MergeTask(new LfasrSignature(this.appId, this.secretKey), taskId));
    }

    public LfasrMessage upload(String audioFilePath) throws LfasrException, SignatureException {
        LfasrMessage message = this.prepare(audioFilePath);
        String taskId = message.getData();
        logger.info("taskId: " + taskId);
        this.uploadFile(taskId, audioFilePath);
        this.mergeFile(taskId);
        return message;
    }

    public LfasrMessage getProgress(String taskId) throws SignatureException {
        return this.lfasrExecutorService.exec(new QueryProgressTask(new LfasrSignature(this.appId, this.secretKey), taskId));
    }

    public LfasrMessage getResult(String taskId) throws SignatureException {
        return this.lfasrExecutorService.exec(new PullResultTask(new LfasrSignature(this.appId, this.secretKey), taskId));
    }

    private void paramHandler(Map<String, String> param, long length, File audio) {
        SLICE_SIZE = this.slice_size == null ? SLICE_SIZE : this.slice_size;
        long sliceNum = length / (long)SLICE_SIZE + (length % (long)SLICE_SIZE == 0L ? 0L : 1L);
        param.put("file_len", length + "");
        param.put("file_name", StringUtils.isNullOrEmpty((String)this.file_name) ? audio.getName() : this.file_name);
        param.put("slice_num", sliceNum + "");
        if (!StringUtils.isNullOrEmpty((String)this.lfasr_type)) {
            param.put("lfasr_type", this.lfasr_type);
        }
        if (!StringUtils.isNullOrEmpty((String)this.has_participle)) {
            param.put("has_participle", this.has_participle);
        }
        if (!StringUtils.isNullOrEmpty((String)this.max_alternatives)) {
            param.put("max_alternatives", this.max_alternatives);
        }
        if (!StringUtils.isNullOrEmpty((String)this.has_seperate)) {
            param.put("has_seperate", this.has_seperate);
        }
        if (!StringUtils.isNullOrEmpty((String)this.speaker_number)) {
            param.put("speaker_number", this.speaker_number);
        }
        if (!StringUtils.isNullOrEmpty((String)this.role_type)) {
            param.put("role_type", this.role_type);
        }
        if (!StringUtils.isNullOrEmpty((String)this.language)) {
            param.put("language", this.language);
        }
        if (!StringUtils.isNullOrEmpty((String)this.pd)) {
            param.put("pd", this.pd);
        }
    }

    public static final class Builder {
        private final String appId;
        private final String secretKey;
        private Integer coreThreads = 10;
        private Integer maxThreads = 50;
        private Integer maxConnections = 50;
        private Integer connTimeout = 10000;
        private Integer soTimeout = 30000;
        private String file_name;
        private Integer slice_size;
        private String lfasr_type;
        private String has_participle;
        private String max_alternatives;
        private String speaker_number;
        private String has_seperate;
        private String role_type;
        private String language;
        private String pd;

        public Builder(String appId, String secretKey) {
            this.appId = appId;
            this.secretKey = secretKey;
        }

        public Builder coreThreads(Integer coreThreads) {
            this.coreThreads = coreThreads;
            return this;
        }

        public Builder maxThreads(Integer maxThreads) {
            this.maxThreads = maxThreads;
            return this;
        }

        public Builder maxConnections(Integer maxConnections) {
            this.maxConnections = maxConnections;
            return this;
        }

        public Builder connTimeout(Integer connTimeout) {
            this.connTimeout = connTimeout;
            return this;
        }

        public Builder soTimeout(Integer soTimeout) {
            this.soTimeout = soTimeout;
            return this;
        }

        public Builder file_name(String file_name) {
            this.file_name = file_name;
            return this;
        }

        public Builder slice(Integer slice_size) {
            this.slice_size = slice_size;
            return this;
        }

        public Builder lfasr_type(String lfasr_type) {
            this.lfasr_type = lfasr_type;
            return this;
        }

        public Builder has_participle(String has_participle) {
            this.has_participle = has_participle;
            return this;
        }

        public Builder max_alternatives(String max_alternatives) {
            this.max_alternatives = max_alternatives;
            return this;
        }

        public Builder speaker_number(String speaker_number) {
            this.speaker_number = speaker_number;
            return this;
        }

        public Builder has_seperate(String has_seperate) {
            this.has_seperate = has_seperate;
            return this;
        }

        public Builder role_type(String role_type) {
            this.role_type = role_type;
            return this;
        }

        public Builder language(String language) {
            this.language = language;
            return this;
        }

        public Builder pd(String pd) {
            this.pd = pd;
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public LfasrClient build() {
            LfasrClient lfasrClient = new LfasrClient(this);
            if (lfasrClient.lfasrExecutorService != null) {
                logger.info("lfasrExecutorService is exist");
            }
            Class<LfasrClient> clazz = LfasrClient.class;
            synchronized (LfasrClient.class) {
                if (lfasrClient.lfasrExecutorService == null) {
                    lfasrClient.lfasrExecutorService = LfasrExecutorService.build(this.coreThreads, this.maxThreads, this.maxConnections, this.connTimeout, this.soTimeout);
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return lfasrClient;
            }
        }
    }
}

