/*
 * Decompiled with CFR 0.152.
 */
package cn.xfyun.api;

import cn.xfyun.base.websocket.WebSocketClient;
import cn.xfyun.model.sign.AbstractSignature;
import cn.xfyun.model.sign.Hmac256Signature;
import cn.xfyun.service.common.AbstractTimedTask;
import cn.xfyun.service.ise.IseSendTask;
import com.google.gson.JsonObject;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.security.SignatureException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okhttp3.internal.Util;

public class IseClient
extends WebSocketClient {
    private JsonObject common;
    private JsonObject business;
    private String sub;
    private String ent;
    private String category;
    private int aus;
    private String cmd;
    private String text;
    private String tte;
    private boolean ttp_skip;
    private String extra_ability;
    private String aue;
    private String auf;
    private String rstcd;
    private String group;
    private String check_type;
    private String grade;
    private String rst = "entirety";
    private String ise_unite = "0";
    private String plev = "0";
    private Integer frameSize;
    private static ExecutorService executorService = Executors.newSingleThreadExecutor();

    public IseClient(Builder builder) {
        this.common = builder.common;
        this.business = builder.business;
        this.appId = builder.appId;
        this.sub = builder.sub;
        this.ent = builder.ent;
        this.category = builder.category;
        this.aus = builder.aus;
        this.cmd = builder.cmd;
        this.text = builder.text;
        this.tte = builder.tte;
        this.ttp_skip = builder.ttpSkip;
        this.extra_ability = builder.extraAbility;
        this.aue = builder.aue;
        this.auf = builder.auf;
        this.rstcd = builder.rstcd;
        this.group = builder.group;
        this.check_type = builder.checkType;
        this.grade = builder.grade;
        this.rst = builder.rst;
        this.ise_unite = builder.iseUnite;
        this.plev = builder.plev;
        this.originHostUrl = builder.hostUrl;
        this.apiKey = builder.apiKey;
        this.apiSecret = builder.apiSecret;
        this.frameSize = builder.frameSize;
        this.request = builder.request;
        this.okHttpClient = new OkHttpClient().newBuilder().build();
        this.signature = builder.signature;
        this.retryOnConnectionFailure = builder.retryOnConnectionFailure;
        this.callTimeout = builder.callTimeout;
        this.connectTimeout = builder.connectTimeout;
        this.readTimeout = builder.readTimeout;
        this.writeTimeout = builder.writeTimeout;
        this.pingInterval = builder.pingInterval;
    }

    public void send(File file, WebSocketListener webSocketListener) throws FileNotFoundException, MalformedURLException, SignatureException {
        this.createWebSocketConnect(webSocketListener);
        FileInputStream fileInputStream = new FileInputStream(file);
        this.send(fileInputStream, webSocketListener);
    }

    public void send(InputStream inputStream, WebSocketListener webSocketListener) throws MalformedURLException, SignatureException {
        this.createWebSocketConnect(webSocketListener);
        if (inputStream == null) {
            this.webSocket.close(1000, null);
            return;
        }
        IseSendTask iseSendTask = new IseSendTask();
        new AbstractTimedTask.Builder().inputStream(inputStream).webSocketClient(this).build(iseSendTask);
        executorService.submit(iseSendTask);
    }

    public void send(byte[] bytes, Closeable closeable, WebSocketListener webSocketListener) throws MalformedURLException, SignatureException {
        this.createWebSocketConnect(webSocketListener);
        if (bytes == null || bytes.length == 0) {
            this.webSocket.close(1000, null);
            return;
        }
        IseSendTask iseSendTask = new IseSendTask();
        new AbstractTimedTask.Builder().bytes(bytes).webSocketClient(this).closeable(closeable).build(iseSendTask);
        executorService.submit(iseSendTask);
    }

    public String getAppId() {
        return this.appId;
    }

    public boolean isTtpSkip() {
        return this.ttp_skip;
    }

    public String getExtraAbility() {
        return this.extra_ability;
    }

    public String getCheckType() {
        return this.check_type;
    }

    public String getIseUnite() {
        return this.ise_unite;
    }

    public String getSub() {
        return this.sub;
    }

    public String getEnt() {
        return this.ent;
    }

    public String getCategory() {
        return this.category;
    }

    public int getAus() {
        return this.aus;
    }

    public String getCmd() {
        return this.cmd;
    }

    public String getText() {
        return this.text;
    }

    public String getTte() {
        return this.tte;
    }

    public String getAue() {
        return this.aue;
    }

    public String getAuf() {
        return this.auf;
    }

    public String getRstcd() {
        return this.rstcd;
    }

    public String getGroup() {
        return this.group;
    }

    public String getGrade() {
        return this.grade;
    }

    public String getRst() {
        return this.rst;
    }

    public String getPlev() {
        return this.plev;
    }

    public String getHostUrl() {
        return this.originHostUrl;
    }

    public String getOriginHostUrl() {
        return this.originHostUrl;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getApiSecret() {
        return this.apiSecret;
    }

    public Request getRequest() {
        return this.request;
    }

    public OkHttpClient getClient() {
        return this.okHttpClient;
    }

    public WebSocket getWebSocket() {
        return this.webSocket;
    }

    public boolean isRetryOnConnectionFailure() {
        return this.retryOnConnectionFailure;
    }

    public int getCallTimeout() {
        return this.callTimeout;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public int getWriteTimeout() {
        return this.writeTimeout;
    }

    public int getPingInterval() {
        return this.pingInterval;
    }

    public AbstractSignature getSignature() {
        return this.signature;
    }

    public Integer getFrameSize() {
        return this.frameSize;
    }

    public static class Builder {
        private JsonObject common = new JsonObject();
        private JsonObject business = new JsonObject();
        private String appId;
        private String sub;
        private String ent;
        private String category;
        private int aus;
        private String cmd;
        private String text;
        private String tte;
        private boolean ttpSkip = true;
        private String extraAbility;
        private String aue = "raw";
        private String auf = "audio/L16;rate=16000";
        private String rstcd = "gbk";
        private String group;
        private String checkType;
        private String grade;
        private String rst = "entirety";
        private String iseUnite = "0";
        private String plev = "0";
        private String hostUrl = "https://ise-api.xfyun.cn/v2/open-ise";
        private String apiKey;
        private String apiSecret;
        private Integer frameSize = 1280;
        private Hmac256Signature signature;
        private Request request;
        private OkHttpClient client;
        boolean retryOnConnectionFailure = true;
        int callTimeout = 0;
        int connectTimeout = 10000;
        int readTimeout = 10000;
        int writeTimeout = 10000;
        int pingInterval = 0;

        public IseClient build() {
            return new IseClient(this);
        }

        public Builder signature(String appId, String apiKey, String secretKey) {
            Hmac256Signature signature;
            this.appId = appId;
            this.apiKey = apiKey;
            this.apiSecret = secretKey;
            this.signature = signature = new Hmac256Signature(apiKey, secretKey, this.hostUrl);
            return this;
        }

        public Builder hostUrl(String hostUrl) {
            this.hostUrl = hostUrl;
            return this;
        }

        public Builder addAppId(String appId) {
            this.appId = appId;
            this.common.addProperty("app_id", appId);
            return this;
        }

        public Builder addSub(String sub) {
            this.business.addProperty("sub", sub);
            this.sub = sub;
            return this;
        }

        public Builder addEnt(String ent) {
            this.ent = ent;
            this.business.addProperty("ent", ent);
            return this;
        }

        public Builder addCategory(String category) {
            this.category = category;
            this.business.addProperty("category", category);
            return this;
        }

        public Builder addAus(int aus) {
            this.aus = aus;
            this.business.addProperty("aus", (Number)aus);
            return this;
        }

        public Builder addCmd(String cmd) {
            this.cmd = cmd;
            this.business.addProperty("cmd", cmd);
            return this;
        }

        public Builder addText(String text) {
            this.text = text;
            this.business.addProperty("text", text);
            return this;
        }

        public Builder addTte(String tte) {
            this.tte = tte;
            this.business.addProperty("tte", tte);
            return this;
        }

        public Builder addTtpSkip(boolean ttpSkip) {
            this.ttpSkip = ttpSkip;
            this.business.addProperty("ttp_skip", Boolean.valueOf(ttpSkip));
            return this;
        }

        public Builder addExtraAbility(String extraAbility) {
            this.extraAbility = extraAbility;
            this.business.addProperty("extra_ability", extraAbility);
            return this;
        }

        public Builder addAue(String aue) {
            this.aue = aue;
            this.business.addProperty("aue", aue);
            return this;
        }

        public Builder addAuf(String auf) {
            this.auf = auf;
            this.business.addProperty("auf", auf);
            return this;
        }

        public Builder addRstcd(String rstcd) {
            this.rstcd = rstcd;
            this.business.addProperty("rstcd", rstcd);
            return this;
        }

        public Builder addGroup(String group) {
            this.group = group;
            this.business.addProperty("group", group);
            return this;
        }

        public Builder addCheckType(String checkType) {
            this.checkType = checkType;
            this.business.addProperty("check_type", checkType);
            return this;
        }

        public Builder addGrade(String grade) {
            this.grade = grade;
            this.business.addProperty("grade", grade);
            return this;
        }

        public Builder addRst(String rst) {
            this.rst = rst;
            this.business.addProperty("rst", rst);
            return this;
        }

        public Builder addIseUnite(String iseUnite) {
            this.iseUnite = iseUnite;
            this.business.addProperty("ise_unite", iseUnite);
            return this;
        }

        public Builder addPlev(String plev) {
            this.plev = plev;
            this.business.addProperty("plev", plev);
            return this;
        }

        public Builder addHostUrl(String hostUrl) {
            this.hostUrl = hostUrl;
            return this;
        }

        public Builder addAppKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public Builder addAppSecret(String apiSecret) {
            this.apiSecret = apiSecret;
            return this;
        }

        public Builder addCommon(JsonObject common) {
            this.common = common;
            return this;
        }

        public Hmac256Signature getSignature() {
            return this.signature;
        }

        public Builder addSignature(Hmac256Signature signature) {
            this.signature = signature;
            return this;
        }

        public Builder addRequest(Request request) {
            this.request = request;
            return this;
        }

        public Builder addClient(OkHttpClient client) {
            this.client = client;
            return this;
        }

        public Builder addBusiness(JsonObject business) {
            this.business = business;
            return this;
        }

        public Builder frameSize(Integer frameSize) {
            this.frameSize = frameSize;
            return this;
        }

        public Builder callTimeout(long timeout, TimeUnit unit) {
            this.callTimeout = Util.checkDuration((String)"timeout", (long)timeout, (TimeUnit)unit);
            return this;
        }

        public Builder connectTimeout(long timeout, TimeUnit unit) {
            this.connectTimeout = Util.checkDuration((String)"timeout", (long)timeout, (TimeUnit)unit);
            return this;
        }

        public Builder readTimeout(long timeout, TimeUnit unit) {
            this.readTimeout = Util.checkDuration((String)"timeout", (long)timeout, (TimeUnit)unit);
            return this;
        }

        public Builder writeTimeout(long timeout, TimeUnit unit) {
            this.writeTimeout = Util.checkDuration((String)"timeout", (long)timeout, (TimeUnit)unit);
            return this;
        }

        public Builder pingInterval(long interval, TimeUnit unit) {
            this.pingInterval = Util.checkDuration((String)"interval", (long)interval, (TimeUnit)unit);
            return this;
        }

        public Builder retryOnConnectionFailure(boolean retryOnConnectionFailure) {
            this.retryOnConnectionFailure = retryOnConnectionFailure;
            return this;
        }
    }
}

