/*
 * Decompiled with CFR 0.152.
 */
package cn.xuyanwu.spring.file.storage;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnMissingBean(value={FileStorageProperties.class})
@ConfigurationProperties(prefix="spring.file-storage")
public class FileStorageProperties {
    private String defaultPlatform = "local";
    private String thumbnailSuffix = ".min.jpg";
    private List<Local> local = new ArrayList<Local>();
    private List<LocalPlus> localPlus = new ArrayList<LocalPlus>();
    private List<HuaweiObs> huaweiObs = new ArrayList<HuaweiObs>();
    private List<AliyunOss> aliyunOss = new ArrayList<AliyunOss>();
    private List<QiniuKodo> qiniuKodo = new ArrayList<QiniuKodo>();
    private List<TencentCos> tencentCos = new ArrayList<TencentCos>();
    private List<BaiduBos> baiduBos = new ArrayList<BaiduBos>();
    private List<UpyunUSS> upyunUSS = new ArrayList<UpyunUSS>();
    private List<MinIO> minio = new ArrayList<MinIO>();
    private List<AwsS3> awsS3 = new ArrayList<AwsS3>();
    private List<FTP> ftp = new ArrayList<FTP>();
    private List<SFTP> sftp = new ArrayList<SFTP>();
    private List<WebDAV> WebDav = new ArrayList<WebDAV>();
    private List<GoogleCloud> googleCloud = new ArrayList<GoogleCloud>();

    public String getDefaultPlatform() {
        return this.defaultPlatform;
    }

    public String getThumbnailSuffix() {
        return this.thumbnailSuffix;
    }

    public List<Local> getLocal() {
        return this.local;
    }

    public List<LocalPlus> getLocalPlus() {
        return this.localPlus;
    }

    public List<HuaweiObs> getHuaweiObs() {
        return this.huaweiObs;
    }

    public List<AliyunOss> getAliyunOss() {
        return this.aliyunOss;
    }

    public List<QiniuKodo> getQiniuKodo() {
        return this.qiniuKodo;
    }

    public List<TencentCos> getTencentCos() {
        return this.tencentCos;
    }

    public List<BaiduBos> getBaiduBos() {
        return this.baiduBos;
    }

    public List<UpyunUSS> getUpyunUSS() {
        return this.upyunUSS;
    }

    public List<MinIO> getMinio() {
        return this.minio;
    }

    public List<AwsS3> getAwsS3() {
        return this.awsS3;
    }

    public List<FTP> getFtp() {
        return this.ftp;
    }

    public List<SFTP> getSftp() {
        return this.sftp;
    }

    public List<WebDAV> getWebDav() {
        return this.WebDav;
    }

    public List<GoogleCloud> getGoogleCloud() {
        return this.googleCloud;
    }

    public void setDefaultPlatform(String defaultPlatform) {
        this.defaultPlatform = defaultPlatform;
    }

    public void setThumbnailSuffix(String thumbnailSuffix) {
        this.thumbnailSuffix = thumbnailSuffix;
    }

    public void setLocal(List<Local> local) {
        this.local = local;
    }

    public void setLocalPlus(List<LocalPlus> localPlus) {
        this.localPlus = localPlus;
    }

    public void setHuaweiObs(List<HuaweiObs> huaweiObs) {
        this.huaweiObs = huaweiObs;
    }

    public void setAliyunOss(List<AliyunOss> aliyunOss) {
        this.aliyunOss = aliyunOss;
    }

    public void setQiniuKodo(List<QiniuKodo> qiniuKodo) {
        this.qiniuKodo = qiniuKodo;
    }

    public void setTencentCos(List<TencentCos> tencentCos) {
        this.tencentCos = tencentCos;
    }

    public void setBaiduBos(List<BaiduBos> baiduBos) {
        this.baiduBos = baiduBos;
    }

    public void setUpyunUSS(List<UpyunUSS> upyunUSS) {
        this.upyunUSS = upyunUSS;
    }

    public void setMinio(List<MinIO> minio) {
        this.minio = minio;
    }

    public void setAwsS3(List<AwsS3> awsS3) {
        this.awsS3 = awsS3;
    }

    public void setFtp(List<FTP> ftp) {
        this.ftp = ftp;
    }

    public void setSftp(List<SFTP> sftp) {
        this.sftp = sftp;
    }

    public void setWebDav(List<WebDAV> WebDav) {
        this.WebDav = WebDav;
    }

    public void setGoogleCloud(List<GoogleCloud> googleCloud) {
        this.googleCloud = googleCloud;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FileStorageProperties)) {
            return false;
        }
        FileStorageProperties other = (FileStorageProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$defaultPlatform = this.getDefaultPlatform();
        String other$defaultPlatform = other.getDefaultPlatform();
        if (this$defaultPlatform == null ? other$defaultPlatform != null : !this$defaultPlatform.equals(other$defaultPlatform)) {
            return false;
        }
        String this$thumbnailSuffix = this.getThumbnailSuffix();
        String other$thumbnailSuffix = other.getThumbnailSuffix();
        if (this$thumbnailSuffix == null ? other$thumbnailSuffix != null : !this$thumbnailSuffix.equals(other$thumbnailSuffix)) {
            return false;
        }
        List<Local> this$local = this.getLocal();
        List<Local> other$local = other.getLocal();
        if (this$local == null ? other$local != null : !((Object)this$local).equals(other$local)) {
            return false;
        }
        List<LocalPlus> this$localPlus = this.getLocalPlus();
        List<LocalPlus> other$localPlus = other.getLocalPlus();
        if (this$localPlus == null ? other$localPlus != null : !((Object)this$localPlus).equals(other$localPlus)) {
            return false;
        }
        List<HuaweiObs> this$huaweiObs = this.getHuaweiObs();
        List<HuaweiObs> other$huaweiObs = other.getHuaweiObs();
        if (this$huaweiObs == null ? other$huaweiObs != null : !((Object)this$huaweiObs).equals(other$huaweiObs)) {
            return false;
        }
        List<AliyunOss> this$aliyunOss = this.getAliyunOss();
        List<AliyunOss> other$aliyunOss = other.getAliyunOss();
        if (this$aliyunOss == null ? other$aliyunOss != null : !((Object)this$aliyunOss).equals(other$aliyunOss)) {
            return false;
        }
        List<QiniuKodo> this$qiniuKodo = this.getQiniuKodo();
        List<QiniuKodo> other$qiniuKodo = other.getQiniuKodo();
        if (this$qiniuKodo == null ? other$qiniuKodo != null : !((Object)this$qiniuKodo).equals(other$qiniuKodo)) {
            return false;
        }
        List<TencentCos> this$tencentCos = this.getTencentCos();
        List<TencentCos> other$tencentCos = other.getTencentCos();
        if (this$tencentCos == null ? other$tencentCos != null : !((Object)this$tencentCos).equals(other$tencentCos)) {
            return false;
        }
        List<BaiduBos> this$baiduBos = this.getBaiduBos();
        List<BaiduBos> other$baiduBos = other.getBaiduBos();
        if (this$baiduBos == null ? other$baiduBos != null : !((Object)this$baiduBos).equals(other$baiduBos)) {
            return false;
        }
        List<UpyunUSS> this$upyunUSS = this.getUpyunUSS();
        List<UpyunUSS> other$upyunUSS = other.getUpyunUSS();
        if (this$upyunUSS == null ? other$upyunUSS != null : !((Object)this$upyunUSS).equals(other$upyunUSS)) {
            return false;
        }
        List<MinIO> this$minio = this.getMinio();
        List<MinIO> other$minio = other.getMinio();
        if (this$minio == null ? other$minio != null : !((Object)this$minio).equals(other$minio)) {
            return false;
        }
        List<AwsS3> this$awsS3 = this.getAwsS3();
        List<AwsS3> other$awsS3 = other.getAwsS3();
        if (this$awsS3 == null ? other$awsS3 != null : !((Object)this$awsS3).equals(other$awsS3)) {
            return false;
        }
        List<FTP> this$ftp = this.getFtp();
        List<FTP> other$ftp = other.getFtp();
        if (this$ftp == null ? other$ftp != null : !((Object)this$ftp).equals(other$ftp)) {
            return false;
        }
        List<SFTP> this$sftp = this.getSftp();
        List<SFTP> other$sftp = other.getSftp();
        if (this$sftp == null ? other$sftp != null : !((Object)this$sftp).equals(other$sftp)) {
            return false;
        }
        List<WebDAV> this$WebDav = this.getWebDav();
        List<WebDAV> other$WebDav = other.getWebDav();
        if (this$WebDav == null ? other$WebDav != null : !((Object)this$WebDav).equals(other$WebDav)) {
            return false;
        }
        List<GoogleCloud> this$googleCloud = this.getGoogleCloud();
        List<GoogleCloud> other$googleCloud = other.getGoogleCloud();
        return !(this$googleCloud == null ? other$googleCloud != null : !((Object)this$googleCloud).equals(other$googleCloud));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FileStorageProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $defaultPlatform = this.getDefaultPlatform();
        result = result * 59 + ($defaultPlatform == null ? 43 : $defaultPlatform.hashCode());
        String $thumbnailSuffix = this.getThumbnailSuffix();
        result = result * 59 + ($thumbnailSuffix == null ? 43 : $thumbnailSuffix.hashCode());
        List<Local> $local = this.getLocal();
        result = result * 59 + ($local == null ? 43 : ((Object)$local).hashCode());
        List<LocalPlus> $localPlus = this.getLocalPlus();
        result = result * 59 + ($localPlus == null ? 43 : ((Object)$localPlus).hashCode());
        List<HuaweiObs> $huaweiObs = this.getHuaweiObs();
        result = result * 59 + ($huaweiObs == null ? 43 : ((Object)$huaweiObs).hashCode());
        List<AliyunOss> $aliyunOss = this.getAliyunOss();
        result = result * 59 + ($aliyunOss == null ? 43 : ((Object)$aliyunOss).hashCode());
        List<QiniuKodo> $qiniuKodo = this.getQiniuKodo();
        result = result * 59 + ($qiniuKodo == null ? 43 : ((Object)$qiniuKodo).hashCode());
        List<TencentCos> $tencentCos = this.getTencentCos();
        result = result * 59 + ($tencentCos == null ? 43 : ((Object)$tencentCos).hashCode());
        List<BaiduBos> $baiduBos = this.getBaiduBos();
        result = result * 59 + ($baiduBos == null ? 43 : ((Object)$baiduBos).hashCode());
        List<UpyunUSS> $upyunUSS = this.getUpyunUSS();
        result = result * 59 + ($upyunUSS == null ? 43 : ((Object)$upyunUSS).hashCode());
        List<MinIO> $minio = this.getMinio();
        result = result * 59 + ($minio == null ? 43 : ((Object)$minio).hashCode());
        List<AwsS3> $awsS3 = this.getAwsS3();
        result = result * 59 + ($awsS3 == null ? 43 : ((Object)$awsS3).hashCode());
        List<FTP> $ftp = this.getFtp();
        result = result * 59 + ($ftp == null ? 43 : ((Object)$ftp).hashCode());
        List<SFTP> $sftp = this.getSftp();
        result = result * 59 + ($sftp == null ? 43 : ((Object)$sftp).hashCode());
        List<WebDAV> $WebDav = this.getWebDav();
        result = result * 59 + ($WebDav == null ? 43 : ((Object)$WebDav).hashCode());
        List<GoogleCloud> $googleCloud = this.getGoogleCloud();
        result = result * 59 + ($googleCloud == null ? 43 : ((Object)$googleCloud).hashCode());
        return result;
    }

    public String toString() {
        return "FileStorageProperties(defaultPlatform=" + this.getDefaultPlatform() + ", thumbnailSuffix=" + this.getThumbnailSuffix() + ", local=" + this.getLocal() + ", localPlus=" + this.getLocalPlus() + ", huaweiObs=" + this.getHuaweiObs() + ", aliyunOss=" + this.getAliyunOss() + ", qiniuKodo=" + this.getQiniuKodo() + ", tencentCos=" + this.getTencentCos() + ", baiduBos=" + this.getBaiduBos() + ", upyunUSS=" + this.getUpyunUSS() + ", minio=" + this.getMinio() + ", awsS3=" + this.getAwsS3() + ", ftp=" + this.getFtp() + ", sftp=" + this.getSftp() + ", WebDav=" + this.getWebDav() + ", googleCloud=" + this.getGoogleCloud() + ")";
    }

    public static class GoogleCloud {
        private String projectId;
        private String credentialsPath;
        private String bucketName;
        private String domain = "";
        private Boolean enableStorage = false;
        private String platform = "";
        private String basePath = "";

        public String getProjectId() {
            return this.projectId;
        }

        public String getCredentialsPath() {
            return this.credentialsPath;
        }

        public String getBucketName() {
            return this.bucketName;
        }

        public String getDomain() {
            return this.domain;
        }

        public Boolean getEnableStorage() {
            return this.enableStorage;
        }

        public String getPlatform() {
            return this.platform;
        }

        public String getBasePath() {
            return this.basePath;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public void setCredentialsPath(String credentialsPath) {
            this.credentialsPath = credentialsPath;
        }

        public void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        public void setDomain(String domain) {
            this.domain = domain;
        }

        public void setEnableStorage(Boolean enableStorage) {
            this.enableStorage = enableStorage;
        }

        public void setPlatform(String platform) {
            this.platform = platform;
        }

        public void setBasePath(String basePath) {
            this.basePath = basePath;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GoogleCloud)) {
                return false;
            }
            GoogleCloud other = (GoogleCloud)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$enableStorage = this.getEnableStorage();
            Boolean other$enableStorage = other.getEnableStorage();
            if (this$enableStorage == null ? other$enableStorage != null : !((Object)this$enableStorage).equals(other$enableStorage)) {
                return false;
            }
            String this$projectId = this.getProjectId();
            String other$projectId = other.getProjectId();
            if (this$projectId == null ? other$projectId != null : !this$projectId.equals(other$projectId)) {
                return false;
            }
            String this$credentialsPath = this.getCredentialsPath();
            String other$credentialsPath = other.getCredentialsPath();
            if (this$credentialsPath == null ? other$credentialsPath != null : !this$credentialsPath.equals(other$credentialsPath)) {
                return false;
            }
            String this$bucketName = this.getBucketName();
            String other$bucketName = other.getBucketName();
            if (this$bucketName == null ? other$bucketName != null : !this$bucketName.equals(other$bucketName)) {
                return false;
            }
            String this$domain = this.getDomain();
            String other$domain = other.getDomain();
            if (this$domain == null ? other$domain != null : !this$domain.equals(other$domain)) {
                return false;
            }
            String this$platform = this.getPlatform();
            String other$platform = other.getPlatform();
            if (this$platform == null ? other$platform != null : !this$platform.equals(other$platform)) {
                return false;
            }
            String this$basePath = this.getBasePath();
            String other$basePath = other.getBasePath();
            return !(this$basePath == null ? other$basePath != null : !this$basePath.equals(other$basePath));
        }

        protected boolean canEqual(Object other) {
            return other instanceof GoogleCloud;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $enableStorage = this.getEnableStorage();
            result = result * 59 + ($enableStorage == null ? 43 : ((Object)$enableStorage).hashCode());
            String $projectId = this.getProjectId();
            result = result * 59 + ($projectId == null ? 43 : $projectId.hashCode());
            String $credentialsPath = this.getCredentialsPath();
            result = result * 59 + ($credentialsPath == null ? 43 : $credentialsPath.hashCode());
            String $bucketName = this.getBucketName();
            result = result * 59 + ($bucketName == null ? 43 : $bucketName.hashCode());
            String $domain = this.getDomain();
            result = result * 59 + ($domain == null ? 43 : $domain.hashCode());
            String $platform = this.getPlatform();
            result = result * 59 + ($platform == null ? 43 : $platform.hashCode());
            String $basePath = this.getBasePath();
            result = result * 59 + ($basePath == null ? 43 : $basePath.hashCode());
            return result;
        }

        public String toString() {
            return "FileStorageProperties.GoogleCloud(projectId=" + this.getProjectId() + ", credentialsPath=" + this.getCredentialsPath() + ", bucketName=" + this.getBucketName() + ", domain=" + this.getDomain() + ", enableStorage=" + this.getEnableStorage() + ", platform=" + this.getPlatform() + ", basePath=" + this.getBasePath() + ")";
        }
    }

    public static class WebDAV {
        private String server;
        private String user;
        private String password;
        private String domain = "";
        private Boolean enableStorage = false;
        private String platform = "";
        private String basePath = "";
        private String storagePath = "/";

        public String getServer() {
            return this.server;
        }

        public String getUser() {
            return this.user;
        }

        public String getPassword() {
            return this.password;
        }

        public String getDomain() {
            return this.domain;
        }

        public Boolean getEnableStorage() {
            return this.enableStorage;
        }

        public String getPlatform() {
            return this.platform;
        }

        public String getBasePath() {
            return this.basePath;
        }

        public String getStoragePath() {
            return this.storagePath;
        }

        public void setServer(String server) {
            this.server = server;
        }

        public void setUser(String user) {
            this.user = user;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public void setDomain(String domain) {
            this.domain = domain;
        }

        public void setEnableStorage(Boolean enableStorage) {
            this.enableStorage = enableStorage;
        }

        public void setPlatform(String platform) {
            this.platform = platform;
        }

        public void setBasePath(String basePath) {
            this.basePath = basePath;
        }

        public void setStoragePath(String storagePath) {
            this.storagePath = storagePath;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WebDAV)) {
                return false;
            }
            WebDAV other = (WebDAV)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$enableStorage = this.getEnableStorage();
            Boolean other$enableStorage = other.getEnableStorage();
            if (this$enableStorage == null ? other$enableStorage != null : !((Object)this$enableStorage).equals(other$enableStorage)) {
                return false;
            }
            String this$server = this.getServer();
            String other$server = other.getServer();
            if (this$server == null ? other$server != null : !this$server.equals(other$server)) {
                return false;
            }
            String this$user = this.getUser();
            String other$user = other.getUser();
            if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
                return false;
            }
            String this$password = this.getPassword();
            String other$password = other.getPassword();
            if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
                return false;
            }
            String this$domain = this.getDomain();
            String other$domain = other.getDomain();
            if (this$domain == null ? other$domain != null : !this$domain.equals(other$domain)) {
                return false;
            }
            String this$platform = this.getPlatform();
            String other$platform = other.getPlatform();
            if (this$platform == null ? other$platform != null : !this$platform.equals(other$platform)) {
                return false;
            }
            String this$basePath = this.getBasePath();
            String other$basePath = other.getBasePath();
            if (this$basePath == null ? other$basePath != null : !this$basePath.equals(other$basePath)) {
                return false;
            }
            String this$storagePath = this.getStoragePath();
            String other$storagePath = other.getStoragePath();
            return !(this$storagePath == null ? other$storagePath != null : !this$storagePath.equals(other$storagePath));
        }

        protected boolean canEqual(Object other) {
            return other instanceof WebDAV;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $enableStorage = this.getEnableStorage();
            result = result * 59 + ($enableStorage == null ? 43 : ((Object)$enableStorage).hashCode());
            String $server = this.getServer();
            result = result * 59 + ($server == null ? 43 : $server.hashCode());
            String $user = this.getUser();
            result = result * 59 + ($user == null ? 43 : $user.hashCode());
            String $password = this.getPassword();
            result = result * 59 + ($password == null ? 43 : $password.hashCode());
            String $domain = this.getDomain();
            result = result * 59 + ($domain == null ? 43 : $domain.hashCode());
            String $platform = this.getPlatform();
            result = result * 59 + ($platform == null ? 43 : $platform.hashCode());
            String $basePath = this.getBasePath();
            result = result * 59 + ($basePath == null ? 43 : $basePath.hashCode());
            String $storagePath = this.getStoragePath();
            result = result * 59 + ($storagePath == null ? 43 : $storagePath.hashCode());
            return result;
        }

        public String toString() {
            return "FileStorageProperties.WebDAV(server=" + this.getServer() + ", user=" + this.getUser() + ", password=" + this.getPassword() + ", domain=" + this.getDomain() + ", enableStorage=" + this.getEnableStorage() + ", platform=" + this.getPlatform() + ", basePath=" + this.getBasePath() + ", storagePath=" + this.getStoragePath() + ")";
        }
    }

    public static class SFTP {
        private String host;
        private int port = 22;
        private String user;
        private String password;
        private String privateKeyPath;
        private Charset charset = StandardCharsets.UTF_8;
        private long connectionTimeout = 10000L;
        private String domain = "";
        private Boolean enableStorage = false;
        private String platform = "";
        private String basePath = "";
        private String storagePath = "/";

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        public String getUser() {
            return this.user;
        }

        public String getPassword() {
            return this.password;
        }

        public String getPrivateKeyPath() {
            return this.privateKeyPath;
        }

        public Charset getCharset() {
            return this.charset;
        }

        public long getConnectionTimeout() {
            return this.connectionTimeout;
        }

        public String getDomain() {
            return this.domain;
        }

        public Boolean getEnableStorage() {
            return this.enableStorage;
        }

        public String getPlatform() {
            return this.platform;
        }

        public String getBasePath() {
            return this.basePath;
        }

        public String getStoragePath() {
            return this.storagePath;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public void setPort(int port) {
            this.port = port;
        }

        public void setUser(String user) {
            this.user = user;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public void setPrivateKeyPath(String privateKeyPath) {
            this.privateKeyPath = privateKeyPath;
        }

        public void setCharset(Charset charset) {
            this.charset = charset;
        }

        public void setConnectionTimeout(long connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
        }

        public void setDomain(String domain) {
            this.domain = domain;
        }

        public void setEnableStorage(Boolean enableStorage) {
            this.enableStorage = enableStorage;
        }

        public void setPlatform(String platform) {
            this.platform = platform;
        }

        public void setBasePath(String basePath) {
            this.basePath = basePath;
        }

        public void setStoragePath(String storagePath) {
            this.storagePath = storagePath;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SFTP)) {
                return false;
            }
            SFTP other = (SFTP)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getPort() != other.getPort()) {
                return false;
            }
            if (this.getConnectionTimeout() != other.getConnectionTimeout()) {
                return false;
            }
            Boolean this$enableStorage = this.getEnableStorage();
            Boolean other$enableStorage = other.getEnableStorage();
            if (this$enableStorage == null ? other$enableStorage != null : !((Object)this$enableStorage).equals(other$enableStorage)) {
                return false;
            }
            String this$host = this.getHost();
            String other$host = other.getHost();
            if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
                return false;
            }
            String this$user = this.getUser();
            String other$user = other.getUser();
            if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
                return false;
            }
            String this$password = this.getPassword();
            String other$password = other.getPassword();
            if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
                return false;
            }
            String this$privateKeyPath = this.getPrivateKeyPath();
            String other$privateKeyPath = other.getPrivateKeyPath();
            if (this$privateKeyPath == null ? other$privateKeyPath != null : !this$privateKeyPath.equals(other$privateKeyPath)) {
                return false;
            }
            Charset this$charset = this.getCharset();
            Charset other$charset = other.getCharset();
            if (this$charset == null ? other$charset != null : !((Object)this$charset).equals(other$charset)) {
                return false;
            }
            String this$domain = this.getDomain();
            String other$domain = other.getDomain();
            if (this$domain == null ? other$domain != null : !this$domain.equals(other$domain)) {
                return false;
            }
            String this$platform = this.getPlatform();
            String other$platform = other.getPlatform();
            if (this$platform == null ? other$platform != null : !this$platform.equals(other$platform)) {
                return false;
            }
            String this$basePath = this.getBasePath();
            String other$basePath = other.getBasePath();
            if (this$basePath == null ? other$basePath != null : !this$basePath.equals(other$basePath)) {
                return false;
            }
            String this$storagePath = this.getStoragePath();
            String other$storagePath = other.getStoragePath();
            return !(this$storagePath == null ? other$storagePath != null : !this$storagePath.equals(other$storagePath));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SFTP;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getPort();
            long $connectionTimeout = this.getConnectionTimeout();
            result = result * 59 + (int)($connectionTimeout >>> 32 ^ $connectionTimeout);
            Boolean $enableStorage = this.getEnableStorage();
            result = result * 59 + ($enableStorage == null ? 43 : ((Object)$enableStorage).hashCode());
            String $host = this.getHost();
            result = result * 59 + ($host == null ? 43 : $host.hashCode());
            String $user = this.getUser();
            result = result * 59 + ($user == null ? 43 : $user.hashCode());
            String $password = this.getPassword();
            result = result * 59 + ($password == null ? 43 : $password.hashCode());
            String $privateKeyPath = this.getPrivateKeyPath();
            result = result * 59 + ($privateKeyPath == null ? 43 : $privateKeyPath.hashCode());
            Charset $charset = this.getCharset();
            result = result * 59 + ($charset == null ? 43 : ((Object)$charset).hashCode());
            String $domain = this.getDomain();
            result = result * 59 + ($domain == null ? 43 : $domain.hashCode());
            String $platform = this.getPlatform();
            result = result * 59 + ($platform == null ? 43 : $platform.hashCode());
            String $basePath = this.getBasePath();
            result = result * 59 + ($basePath == null ? 43 : $basePath.hashCode());
            String $storagePath = this.getStoragePath();
            result = result * 59 + ($storagePath == null ? 43 : $storagePath.hashCode());
            return result;
        }

        public String toString() {
            return "FileStorageProperties.SFTP(host=" + this.getHost() + ", port=" + this.getPort() + ", user=" + this.getUser() + ", password=" + this.getPassword() + ", privateKeyPath=" + this.getPrivateKeyPath() + ", charset=" + this.getCharset() + ", connectionTimeout=" + this.getConnectionTimeout() + ", domain=" + this.getDomain() + ", enableStorage=" + this.getEnableStorage() + ", platform=" + this.getPlatform() + ", basePath=" + this.getBasePath() + ", storagePath=" + this.getStoragePath() + ")";
        }
    }

    public static class FTP {
        private String host;
        private int port = 21;
        private String user = "anonymous";
        private String password = "";
        private Charset charset = StandardCharsets.UTF_8;
        private long connectionTimeout = 10000L;
        private long soTimeout = 10000L;
        private String serverLanguageCode;
        private String systemKey;
        private Boolean isActive = false;
        private String domain = "";
        private Boolean enableStorage = false;
        private String platform = "";
        private String basePath = "";
        private String storagePath = "/";

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        public String getUser() {
            return this.user;
        }

        public String getPassword() {
            return this.password;
        }

        public Charset getCharset() {
            return this.charset;
        }

        public long getConnectionTimeout() {
            return this.connectionTimeout;
        }

        public long getSoTimeout() {
            return this.soTimeout;
        }

        public String getServerLanguageCode() {
            return this.serverLanguageCode;
        }

        public String getSystemKey() {
            return this.systemKey;
        }

        public Boolean getIsActive() {
            return this.isActive;
        }

        public String getDomain() {
            return this.domain;
        }

        public Boolean getEnableStorage() {
            return this.enableStorage;
        }

        public String getPlatform() {
            return this.platform;
        }

        public String getBasePath() {
            return this.basePath;
        }

        public String getStoragePath() {
            return this.storagePath;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public void setPort(int port) {
            this.port = port;
        }

        public void setUser(String user) {
            this.user = user;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public void setCharset(Charset charset) {
            this.charset = charset;
        }

        public void setConnectionTimeout(long connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
        }

        public void setSoTimeout(long soTimeout) {
            this.soTimeout = soTimeout;
        }

        public void setServerLanguageCode(String serverLanguageCode) {
            this.serverLanguageCode = serverLanguageCode;
        }

        public void setSystemKey(String systemKey) {
            this.systemKey = systemKey;
        }

        public void setIsActive(Boolean isActive) {
            this.isActive = isActive;
        }

        public void setDomain(String domain) {
            this.domain = domain;
        }

        public void setEnableStorage(Boolean enableStorage) {
            this.enableStorage = enableStorage;
        }

        public void setPlatform(String platform) {
            this.platform = platform;
        }

        public void setBasePath(String basePath) {
            this.basePath = basePath;
        }

        public void setStoragePath(String storagePath) {
            this.storagePath = storagePath;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FTP)) {
                return false;
            }
            FTP other = (FTP)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getPort() != other.getPort()) {
                return false;
            }
            if (this.getConnectionTimeout() != other.getConnectionTimeout()) {
                return false;
            }
            if (this.getSoTimeout() != other.getSoTimeout()) {
                return false;
            }
            Boolean this$isActive = this.getIsActive();
            Boolean other$isActive = other.getIsActive();
            if (this$isActive == null ? other$isActive != null : !((Object)this$isActive).equals(other$isActive)) {
                return false;
            }
            Boolean this$enableStorage = this.getEnableStorage();
            Boolean other$enableStorage = other.getEnableStorage();
            if (this$enableStorage == null ? other$enableStorage != null : !((Object)this$enableStorage).equals(other$enableStorage)) {
                return false;
            }
            String this$host = this.getHost();
            String other$host = other.getHost();
            if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
                return false;
            }
            String this$user = this.getUser();
            String other$user = other.getUser();
            if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
                return false;
            }
            String this$password = this.getPassword();
            String other$password = other.getPassword();
            if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
                return false;
            }
            Charset this$charset = this.getCharset();
            Charset other$charset = other.getCharset();
            if (this$charset == null ? other$charset != null : !((Object)this$charset).equals(other$charset)) {
                return false;
            }
            String this$serverLanguageCode = this.getServerLanguageCode();
            String other$serverLanguageCode = other.getServerLanguageCode();
            if (this$serverLanguageCode == null ? other$serverLanguageCode != null : !this$serverLanguageCode.equals(other$serverLanguageCode)) {
                return false;
            }
            String this$systemKey = this.getSystemKey();
            String other$systemKey = other.getSystemKey();
            if (this$systemKey == null ? other$systemKey != null : !this$systemKey.equals(other$systemKey)) {
                return false;
            }
            String this$domain = this.getDomain();
            String other$domain = other.getDomain();
            if (this$domain == null ? other$domain != null : !this$domain.equals(other$domain)) {
                return false;
            }
            String this$platform = this.getPlatform();
            String other$platform = other.getPlatform();
            if (this$platform == null ? other$platform != null : !this$platform.equals(other$platform)) {
                return false;
            }
            String this$basePath = this.getBasePath();
            String other$basePath = other.getBasePath();
            if (this$basePath == null ? other$basePath != null : !this$basePath.equals(other$basePath)) {
                return false;
            }
            String this$storagePath = this.getStoragePath();
            String other$storagePath = other.getStoragePath();
            return !(this$storagePath == null ? other$storagePath != null : !this$storagePath.equals(other$storagePath));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FTP;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getPort();
            long $connectionTimeout = this.getConnectionTimeout();
            result = result * 59 + (int)($connectionTimeout >>> 32 ^ $connectionTimeout);
            long $soTimeout = this.getSoTimeout();
            result = result * 59 + (int)($soTimeout >>> 32 ^ $soTimeout);
            Boolean $isActive = this.getIsActive();
            result = result * 59 + ($isActive == null ? 43 : ((Object)$isActive).hashCode());
            Boolean $enableStorage = this.getEnableStorage();
            result = result * 59 + ($enableStorage == null ? 43 : ((Object)$enableStorage).hashCode());
            String $host = this.getHost();
            result = result * 59 + ($host == null ? 43 : $host.hashCode());
            String $user = this.getUser();
            result = result * 59 + ($user == null ? 43 : $user.hashCode());
            String $password = this.getPassword();
            result = result * 59 + ($password == null ? 43 : $password.hashCode());
            Charset $charset = this.getCharset();
            result = result * 59 + ($charset == null ? 43 : ((Object)$charset).hashCode());
            String $serverLanguageCode = this.getServerLanguageCode();
            result = result * 59 + ($serverLanguageCode == null ? 43 : $serverLanguageCode.hashCode());
            String $systemKey = this.getSystemKey();
            result = result * 59 + ($systemKey == null ? 43 : $systemKey.hashCode());
            String $domain = this.getDomain();
            result = result * 59 + ($domain == null ? 43 : $domain.hashCode());
            String $platform = this.getPlatform();
            result = result * 59 + ($platform == null ? 43 : $platform.hashCode());
            String $basePath = this.getBasePath();
            result = result * 59 + ($basePath == null ? 43 : $basePath.hashCode());
            String $storagePath = this.getStoragePath();
            result = result * 59 + ($storagePath == null ? 43 : $storagePath.hashCode());
            return result;
        }

        public String toString() {
            return "FileStorageProperties.FTP(host=" + this.getHost() + ", port=" + this.getPort() + ", user=" + this.getUser() + ", password=" + this.getPassword() + ", charset=" + this.getCharset() + ", connectionTimeout=" + this.getConnectionTimeout() + ", soTimeout=" + this.getSoTimeout() + ", serverLanguageCode=" + this.getServerLanguageCode() + ", systemKey=" + this.getSystemKey() + ", isActive=" + this.getIsActive() + ", domain=" + this.getDomain() + ", enableStorage=" + this.getEnableStorage() + ", platform=" + this.getPlatform() + ", basePath=" + this.getBasePath() + ", storagePath=" + this.getStoragePath() + ")";
        }
    }

    public static class AwsS3 {
        private String accessKey;
        private String secretKey;
        private String region;
        private String endPoint;
        private String bucketName;
        private String domain = "";
        private Boolean enableStorage = false;
        private String platform = "";
        private String basePath = "";

        public String getAccessKey() {
            return this.accessKey;
        }

        public String getSecretKey() {
            return this.secretKey;
        }

        public String getRegion() {
            return this.region;
        }

        public String getEndPoint() {
            return this.endPoint;
        }

        public String getBucketName() {
            return this.bucketName;
        }

        public String getDomain() {
            return this.domain;
        }

        public Boolean getEnableStorage() {
            return this.enableStorage;
        }

        public String getPlatform() {
            return this.platform;
        }

        public String getBasePath() {
            return this.basePath;
        }

        public void setAccessKey(String accessKey) {
            this.accessKey = accessKey;
        }

        public void setSecretKey(String secretKey) {
            this.secretKey = secretKey;
        }

        public void setRegion(String region) {
            this.region = region;
        }

        public void setEndPoint(String endPoint) {
            this.endPoint = endPoint;
        }

        public void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        public void setDomain(String domain) {
            this.domain = domain;
        }

        public void setEnableStorage(Boolean enableStorage) {
            this.enableStorage = enableStorage;
        }

        public void setPlatform(String platform) {
            this.platform = platform;
        }

        public void setBasePath(String basePath) {
            this.basePath = basePath;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AwsS3)) {
                return false;
            }
            AwsS3 other = (AwsS3)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$enableStorage = this.getEnableStorage();
            Boolean other$enableStorage = other.getEnableStorage();
            if (this$enableStorage == null ? other$enableStorage != null : !((Object)this$enableStorage).equals(other$enableStorage)) {
                return false;
            }
            String this$accessKey = this.getAccessKey();
            String other$accessKey = other.getAccessKey();
            if (this$accessKey == null ? other$accessKey != null : !this$accessKey.equals(other$accessKey)) {
                return false;
            }
            String this$secretKey = this.getSecretKey();
            String other$secretKey = other.getSecretKey();
            if (this$secretKey == null ? other$secretKey != null : !this$secretKey.equals(other$secretKey)) {
                return false;
            }
            String this$region = this.getRegion();
            String other$region = other.getRegion();
            if (this$region == null ? other$region != null : !this$region.equals(other$region)) {
                return false;
            }
            String this$endPoint = this.getEndPoint();
            String other$endPoint = other.getEndPoint();
            if (this$endPoint == null ? other$endPoint != null : !this$endPoint.equals(other$endPoint)) {
                return false;
            }
            String this$bucketName = this.getBucketName();
            String other$bucketName = other.getBucketName();
            if (this$bucketName == null ? other$bucketName != null : !this$bucketName.equals(other$bucketName)) {
                return false;
            }
            String this$domain = this.getDomain();
            String other$domain = other.getDomain();
            if (this$domain == null ? other$domain != null : !this$domain.equals(other$domain)) {
                return false;
            }
            String this$platform = this.getPlatform();
            String other$platform = other.getPlatform();
            if (this$platform == null ? other$platform != null : !this$platform.equals(other$platform)) {
                return false;
            }
            String this$basePath = this.getBasePath();
            String other$basePath = other.getBasePath();
            return !(this$basePath == null ? other$basePath != null : !this$basePath.equals(other$basePath));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AwsS3;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $enableStorage = this.getEnableStorage();
            result = result * 59 + ($enableStorage == null ? 43 : ((Object)$enableStorage).hashCode());
            String $accessKey = this.getAccessKey();
            result = result * 59 + ($accessKey == null ? 43 : $accessKey.hashCode());
            String $secretKey = this.getSecretKey();
            result = result * 59 + ($secretKey == null ? 43 : $secretKey.hashCode());
            String $region = this.getRegion();
            result = result * 59 + ($region == null ? 43 : $region.hashCode());
            String $endPoint = this.getEndPoint();
            result = result * 59 + ($endPoint == null ? 43 : $endPoint.hashCode());
            String $bucketName = this.getBucketName();
            result = result * 59 + ($bucketName == null ? 43 : $bucketName.hashCode());
            String $domain = this.getDomain();
            result = result * 59 + ($domain == null ? 43 : $domain.hashCode());
            String $platform = this.getPlatform();
            result = result * 59 + ($platform == null ? 43 : $platform.hashCode());
            String $basePath = this.getBasePath();
            result = result * 59 + ($basePath == null ? 43 : $basePath.hashCode());
            return result;
        }

        public String toString() {
            return "FileStorageProperties.AwsS3(accessKey=" + this.getAccessKey() + ", secretKey=" + this.getSecretKey() + ", region=" + this.getRegion() + ", endPoint=" + this.getEndPoint() + ", bucketName=" + this.getBucketName() + ", domain=" + this.getDomain() + ", enableStorage=" + this.getEnableStorage() + ", platform=" + this.getPlatform() + ", basePath=" + this.getBasePath() + ")";
        }
    }

    public static class MinIO {
        private String accessKey;
        private String secretKey;
        private String endPoint;
        private String bucketName;
        private String domain = "";
        private Boolean enableStorage = false;
        private String platform = "";
        private String basePath = "";

        public String getAccessKey() {
            return this.accessKey;
        }

        public String getSecretKey() {
            return this.secretKey;
        }

        public String getEndPoint() {
            return this.endPoint;
        }

        public String getBucketName() {
            return this.bucketName;
        }

        public String getDomain() {
            return this.domain;
        }

        public Boolean getEnableStorage() {
            return this.enableStorage;
        }

        public String getPlatform() {
            return this.platform;
        }

        public String getBasePath() {
            return this.basePath;
        }

        public void setAccessKey(String accessKey) {
            this.accessKey = accessKey;
        }

        public void setSecretKey(String secretKey) {
            this.secretKey = secretKey;
        }

        public void setEndPoint(String endPoint) {
            this.endPoint = endPoint;
        }

        public void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        public void setDomain(String domain) {
            this.domain = domain;
        }

        public void setEnableStorage(Boolean enableStorage) {
            this.enableStorage = enableStorage;
        }

        public void setPlatform(String platform) {
            this.platform = platform;
        }

        public void setBasePath(String basePath) {
            this.basePath = basePath;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MinIO)) {
                return false;
            }
            MinIO other = (MinIO)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$enableStorage = this.getEnableStorage();
            Boolean other$enableStorage = other.getEnableStorage();
            if (this$enableStorage == null ? other$enableStorage != null : !((Object)this$enableStorage).equals(other$enableStorage)) {
                return false;
            }
            String this$accessKey = this.getAccessKey();
            String other$accessKey = other.getAccessKey();
            if (this$accessKey == null ? other$accessKey != null : !this$accessKey.equals(other$accessKey)) {
                return false;
            }
            String this$secretKey = this.getSecretKey();
            String other$secretKey = other.getSecretKey();
            if (this$secretKey == null ? other$secretKey != null : !this$secretKey.equals(other$secretKey)) {
                return false;
            }
            String this$endPoint = this.getEndPoint();
            String other$endPoint = other.getEndPoint();
            if (this$endPoint == null ? other$endPoint != null : !this$endPoint.equals(other$endPoint)) {
                return false;
            }
            String this$bucketName = this.getBucketName();
            String other$bucketName = other.getBucketName();
            if (this$bucketName == null ? other$bucketName != null : !this$bucketName.equals(other$bucketName)) {
                return false;
            }
            String this$domain = this.getDomain();
            String other$domain = other.getDomain();
            if (this$domain == null ? other$domain != null : !this$domain.equals(other$domain)) {
                return false;
            }
            String this$platform = this.getPlatform();
            String other$platform = other.getPlatform();
            if (this$platform == null ? other$platform != null : !this$platform.equals(other$platform)) {
                return false;
            }
            String this$basePath = this.getBasePath();
            String other$basePath = other.getBasePath();
            return !(this$basePath == null ? other$basePath != null : !this$basePath.equals(other$basePath));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MinIO;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $enableStorage = this.getEnableStorage();
            result = result * 59 + ($enableStorage == null ? 43 : ((Object)$enableStorage).hashCode());
            String $accessKey = this.getAccessKey();
            result = result * 59 + ($accessKey == null ? 43 : $accessKey.hashCode());
            String $secretKey = this.getSecretKey();
            result = result * 59 + ($secretKey == null ? 43 : $secretKey.hashCode());
            String $endPoint = this.getEndPoint();
            result = result * 59 + ($endPoint == null ? 43 : $endPoint.hashCode());
            String $bucketName = this.getBucketName();
            result = result * 59 + ($bucketName == null ? 43 : $bucketName.hashCode());
            String $domain = this.getDomain();
            result = result * 59 + ($domain == null ? 43 : $domain.hashCode());
            String $platform = this.getPlatform();
            result = result * 59 + ($platform == null ? 43 : $platform.hashCode());
            String $basePath = this.getBasePath();
            result = result * 59 + ($basePath == null ? 43 : $basePath.hashCode());
            return result;
        }

        public String toString() {
            return "FileStorageProperties.MinIO(accessKey=" + this.getAccessKey() + ", secretKey=" + this.getSecretKey() + ", endPoint=" + this.getEndPoint() + ", bucketName=" + this.getBucketName() + ", domain=" + this.getDomain() + ", enableStorage=" + this.getEnableStorage() + ", platform=" + this.getPlatform() + ", basePath=" + this.getBasePath() + ")";
        }
    }

    public static class UpyunUSS {
        private String username;
        private String password;
        private String bucketName;
        private String domain = "";
        private Boolean enableStorage = false;
        private String platform = "";
        private String basePath = "";

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }

        public String getBucketName() {
            return this.bucketName;
        }

        public String getDomain() {
            return this.domain;
        }

        public Boolean getEnableStorage() {
            return this.enableStorage;
        }

        public String getPlatform() {
            return this.platform;
        }

        public String getBasePath() {
            return this.basePath;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        public void setDomain(String domain) {
            this.domain = domain;
        }

        public void setEnableStorage(Boolean enableStorage) {
            this.enableStorage = enableStorage;
        }

        public void setPlatform(String platform) {
            this.platform = platform;
        }

        public void setBasePath(String basePath) {
            this.basePath = basePath;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UpyunUSS)) {
                return false;
            }
            UpyunUSS other = (UpyunUSS)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$enableStorage = this.getEnableStorage();
            Boolean other$enableStorage = other.getEnableStorage();
            if (this$enableStorage == null ? other$enableStorage != null : !((Object)this$enableStorage).equals(other$enableStorage)) {
                return false;
            }
            String this$username = this.getUsername();
            String other$username = other.getUsername();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            String this$password = this.getPassword();
            String other$password = other.getPassword();
            if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
                return false;
            }
            String this$bucketName = this.getBucketName();
            String other$bucketName = other.getBucketName();
            if (this$bucketName == null ? other$bucketName != null : !this$bucketName.equals(other$bucketName)) {
                return false;
            }
            String this$domain = this.getDomain();
            String other$domain = other.getDomain();
            if (this$domain == null ? other$domain != null : !this$domain.equals(other$domain)) {
                return false;
            }
            String this$platform = this.getPlatform();
            String other$platform = other.getPlatform();
            if (this$platform == null ? other$platform != null : !this$platform.equals(other$platform)) {
                return false;
            }
            String this$basePath = this.getBasePath();
            String other$basePath = other.getBasePath();
            return !(this$basePath == null ? other$basePath != null : !this$basePath.equals(other$basePath));
        }

        protected boolean canEqual(Object other) {
            return other instanceof UpyunUSS;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $enableStorage = this.getEnableStorage();
            result = result * 59 + ($enableStorage == null ? 43 : ((Object)$enableStorage).hashCode());
            String $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            String $password = this.getPassword();
            result = result * 59 + ($password == null ? 43 : $password.hashCode());
            String $bucketName = this.getBucketName();
            result = result * 59 + ($bucketName == null ? 43 : $bucketName.hashCode());
            String $domain = this.getDomain();
            result = result * 59 + ($domain == null ? 43 : $domain.hashCode());
            String $platform = this.getPlatform();
            result = result * 59 + ($platform == null ? 43 : $platform.hashCode());
            String $basePath = this.getBasePath();
            result = result * 59 + ($basePath == null ? 43 : $basePath.hashCode());
            return result;
        }

        public String toString() {
            return "FileStorageProperties.UpyunUSS(username=" + this.getUsername() + ", password=" + this.getPassword() + ", bucketName=" + this.getBucketName() + ", domain=" + this.getDomain() + ", enableStorage=" + this.getEnableStorage() + ", platform=" + this.getPlatform() + ", basePath=" + this.getBasePath() + ")";
        }
    }

    public static class BaiduBos {
        private String accessKey;
        private String secretKey;
        private String endPoint;
        private String bucketName;
        private String domain = "";
        private Boolean enableStorage = false;
        private String platform = "";
        private String basePath = "";

        public String getAccessKey() {
            return this.accessKey;
        }

        public String getSecretKey() {
            return this.secretKey;
        }

        public String getEndPoint() {
            return this.endPoint;
        }

        public String getBucketName() {
            return this.bucketName;
        }

        public String getDomain() {
            return this.domain;
        }

        public Boolean getEnableStorage() {
            return this.enableStorage;
        }

        public String getPlatform() {
            return this.platform;
        }

        public String getBasePath() {
            return this.basePath;
        }

        public void setAccessKey(String accessKey) {
            this.accessKey = accessKey;
        }

        public void setSecretKey(String secretKey) {
            this.secretKey = secretKey;
        }

        public void setEndPoint(String endPoint) {
            this.endPoint = endPoint;
        }

        public void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        public void setDomain(String domain) {
            this.domain = domain;
        }

        public void setEnableStorage(Boolean enableStorage) {
            this.enableStorage = enableStorage;
        }

        public void setPlatform(String platform) {
            this.platform = platform;
        }

        public void setBasePath(String basePath) {
            this.basePath = basePath;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BaiduBos)) {
                return false;
            }
            BaiduBos other = (BaiduBos)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$enableStorage = this.getEnableStorage();
            Boolean other$enableStorage = other.getEnableStorage();
            if (this$enableStorage == null ? other$enableStorage != null : !((Object)this$enableStorage).equals(other$enableStorage)) {
                return false;
            }
            String this$accessKey = this.getAccessKey();
            String other$accessKey = other.getAccessKey();
            if (this$accessKey == null ? other$accessKey != null : !this$accessKey.equals(other$accessKey)) {
                return false;
            }
            String this$secretKey = this.getSecretKey();
            String other$secretKey = other.getSecretKey();
            if (this$secretKey == null ? other$secretKey != null : !this$secretKey.equals(other$secretKey)) {
                return false;
            }
            String this$endPoint = this.getEndPoint();
            String other$endPoint = other.getEndPoint();
            if (this$endPoint == null ? other$endPoint != null : !this$endPoint.equals(other$endPoint)) {
                return false;
            }
            String this$bucketName = this.getBucketName();
            String other$bucketName = other.getBucketName();
            if (this$bucketName == null ? other$bucketName != null : !this$bucketName.equals(other$bucketName)) {
                return false;
            }
            String this$domain = this.getDomain();
            String other$domain = other.getDomain();
            if (this$domain == null ? other$domain != null : !this$domain.equals(other$domain)) {
                return false;
            }
            String this$platform = this.getPlatform();
            String other$platform = other.getPlatform();
            if (this$platform == null ? other$platform != null : !this$platform.equals(other$platform)) {
                return false;
            }
            String this$basePath = this.getBasePath();
            String other$basePath = other.getBasePath();
            return !(this$basePath == null ? other$basePath != null : !this$basePath.equals(other$basePath));
        }

        protected boolean canEqual(Object other) {
            return other instanceof BaiduBos;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $enableStorage = this.getEnableStorage();
            result = result * 59 + ($enableStorage == null ? 43 : ((Object)$enableStorage).hashCode());
            String $accessKey = this.getAccessKey();
            result = result * 59 + ($accessKey == null ? 43 : $accessKey.hashCode());
            String $secretKey = this.getSecretKey();
            result = result * 59 + ($secretKey == null ? 43 : $secretKey.hashCode());
            String $endPoint = this.getEndPoint();
            result = result * 59 + ($endPoint == null ? 43 : $endPoint.hashCode());
            String $bucketName = this.getBucketName();
            result = result * 59 + ($bucketName == null ? 43 : $bucketName.hashCode());
            String $domain = this.getDomain();
            result = result * 59 + ($domain == null ? 43 : $domain.hashCode());
            String $platform = this.getPlatform();
            result = result * 59 + ($platform == null ? 43 : $platform.hashCode());
            String $basePath = this.getBasePath();
            result = result * 59 + ($basePath == null ? 43 : $basePath.hashCode());
            return result;
        }

        public String toString() {
            return "FileStorageProperties.BaiduBos(accessKey=" + this.getAccessKey() + ", secretKey=" + this.getSecretKey() + ", endPoint=" + this.getEndPoint() + ", bucketName=" + this.getBucketName() + ", domain=" + this.getDomain() + ", enableStorage=" + this.getEnableStorage() + ", platform=" + this.getPlatform() + ", basePath=" + this.getBasePath() + ")";
        }
    }

    public static class TencentCos {
        private String secretId;
        private String secretKey;
        private String region;
        private String bucketName;
        private String domain = "";
        private Boolean enableStorage = false;
        private String platform = "";
        private String basePath = "";

        public String getSecretId() {
            return this.secretId;
        }

        public String getSecretKey() {
            return this.secretKey;
        }

        public String getRegion() {
            return this.region;
        }

        public String getBucketName() {
            return this.bucketName;
        }

        public String getDomain() {
            return this.domain;
        }

        public Boolean getEnableStorage() {
            return this.enableStorage;
        }

        public String getPlatform() {
            return this.platform;
        }

        public String getBasePath() {
            return this.basePath;
        }

        public void setSecretId(String secretId) {
            this.secretId = secretId;
        }

        public void setSecretKey(String secretKey) {
            this.secretKey = secretKey;
        }

        public void setRegion(String region) {
            this.region = region;
        }

        public void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        public void setDomain(String domain) {
            this.domain = domain;
        }

        public void setEnableStorage(Boolean enableStorage) {
            this.enableStorage = enableStorage;
        }

        public void setPlatform(String platform) {
            this.platform = platform;
        }

        public void setBasePath(String basePath) {
            this.basePath = basePath;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TencentCos)) {
                return false;
            }
            TencentCos other = (TencentCos)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$enableStorage = this.getEnableStorage();
            Boolean other$enableStorage = other.getEnableStorage();
            if (this$enableStorage == null ? other$enableStorage != null : !((Object)this$enableStorage).equals(other$enableStorage)) {
                return false;
            }
            String this$secretId = this.getSecretId();
            String other$secretId = other.getSecretId();
            if (this$secretId == null ? other$secretId != null : !this$secretId.equals(other$secretId)) {
                return false;
            }
            String this$secretKey = this.getSecretKey();
            String other$secretKey = other.getSecretKey();
            if (this$secretKey == null ? other$secretKey != null : !this$secretKey.equals(other$secretKey)) {
                return false;
            }
            String this$region = this.getRegion();
            String other$region = other.getRegion();
            if (this$region == null ? other$region != null : !this$region.equals(other$region)) {
                return false;
            }
            String this$bucketName = this.getBucketName();
            String other$bucketName = other.getBucketName();
            if (this$bucketName == null ? other$bucketName != null : !this$bucketName.equals(other$bucketName)) {
                return false;
            }
            String this$domain = this.getDomain();
            String other$domain = other.getDomain();
            if (this$domain == null ? other$domain != null : !this$domain.equals(other$domain)) {
                return false;
            }
            String this$platform = this.getPlatform();
            String other$platform = other.getPlatform();
            if (this$platform == null ? other$platform != null : !this$platform.equals(other$platform)) {
                return false;
            }
            String this$basePath = this.getBasePath();
            String other$basePath = other.getBasePath();
            return !(this$basePath == null ? other$basePath != null : !this$basePath.equals(other$basePath));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TencentCos;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $enableStorage = this.getEnableStorage();
            result = result * 59 + ($enableStorage == null ? 43 : ((Object)$enableStorage).hashCode());
            String $secretId = this.getSecretId();
            result = result * 59 + ($secretId == null ? 43 : $secretId.hashCode());
            String $secretKey = this.getSecretKey();
            result = result * 59 + ($secretKey == null ? 43 : $secretKey.hashCode());
            String $region = this.getRegion();
            result = result * 59 + ($region == null ? 43 : $region.hashCode());
            String $bucketName = this.getBucketName();
            result = result * 59 + ($bucketName == null ? 43 : $bucketName.hashCode());
            String $domain = this.getDomain();
            result = result * 59 + ($domain == null ? 43 : $domain.hashCode());
            String $platform = this.getPlatform();
            result = result * 59 + ($platform == null ? 43 : $platform.hashCode());
            String $basePath = this.getBasePath();
            result = result * 59 + ($basePath == null ? 43 : $basePath.hashCode());
            return result;
        }

        public String toString() {
            return "FileStorageProperties.TencentCos(secretId=" + this.getSecretId() + ", secretKey=" + this.getSecretKey() + ", region=" + this.getRegion() + ", bucketName=" + this.getBucketName() + ", domain=" + this.getDomain() + ", enableStorage=" + this.getEnableStorage() + ", platform=" + this.getPlatform() + ", basePath=" + this.getBasePath() + ")";
        }
    }

    public static class QiniuKodo {
        private String accessKey;
        private String secretKey;
        private String bucketName;
        private String domain = "";
        private Boolean enableStorage = false;
        private String platform = "";
        private String basePath = "";

        public String getAccessKey() {
            return this.accessKey;
        }

        public String getSecretKey() {
            return this.secretKey;
        }

        public String getBucketName() {
            return this.bucketName;
        }

        public String getDomain() {
            return this.domain;
        }

        public Boolean getEnableStorage() {
            return this.enableStorage;
        }

        public String getPlatform() {
            return this.platform;
        }

        public String getBasePath() {
            return this.basePath;
        }

        public void setAccessKey(String accessKey) {
            this.accessKey = accessKey;
        }

        public void setSecretKey(String secretKey) {
            this.secretKey = secretKey;
        }

        public void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        public void setDomain(String domain) {
            this.domain = domain;
        }

        public void setEnableStorage(Boolean enableStorage) {
            this.enableStorage = enableStorage;
        }

        public void setPlatform(String platform) {
            this.platform = platform;
        }

        public void setBasePath(String basePath) {
            this.basePath = basePath;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof QiniuKodo)) {
                return false;
            }
            QiniuKodo other = (QiniuKodo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$enableStorage = this.getEnableStorage();
            Boolean other$enableStorage = other.getEnableStorage();
            if (this$enableStorage == null ? other$enableStorage != null : !((Object)this$enableStorage).equals(other$enableStorage)) {
                return false;
            }
            String this$accessKey = this.getAccessKey();
            String other$accessKey = other.getAccessKey();
            if (this$accessKey == null ? other$accessKey != null : !this$accessKey.equals(other$accessKey)) {
                return false;
            }
            String this$secretKey = this.getSecretKey();
            String other$secretKey = other.getSecretKey();
            if (this$secretKey == null ? other$secretKey != null : !this$secretKey.equals(other$secretKey)) {
                return false;
            }
            String this$bucketName = this.getBucketName();
            String other$bucketName = other.getBucketName();
            if (this$bucketName == null ? other$bucketName != null : !this$bucketName.equals(other$bucketName)) {
                return false;
            }
            String this$domain = this.getDomain();
            String other$domain = other.getDomain();
            if (this$domain == null ? other$domain != null : !this$domain.equals(other$domain)) {
                return false;
            }
            String this$platform = this.getPlatform();
            String other$platform = other.getPlatform();
            if (this$platform == null ? other$platform != null : !this$platform.equals(other$platform)) {
                return false;
            }
            String this$basePath = this.getBasePath();
            String other$basePath = other.getBasePath();
            return !(this$basePath == null ? other$basePath != null : !this$basePath.equals(other$basePath));
        }

        protected boolean canEqual(Object other) {
            return other instanceof QiniuKodo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $enableStorage = this.getEnableStorage();
            result = result * 59 + ($enableStorage == null ? 43 : ((Object)$enableStorage).hashCode());
            String $accessKey = this.getAccessKey();
            result = result * 59 + ($accessKey == null ? 43 : $accessKey.hashCode());
            String $secretKey = this.getSecretKey();
            result = result * 59 + ($secretKey == null ? 43 : $secretKey.hashCode());
            String $bucketName = this.getBucketName();
            result = result * 59 + ($bucketName == null ? 43 : $bucketName.hashCode());
            String $domain = this.getDomain();
            result = result * 59 + ($domain == null ? 43 : $domain.hashCode());
            String $platform = this.getPlatform();
            result = result * 59 + ($platform == null ? 43 : $platform.hashCode());
            String $basePath = this.getBasePath();
            result = result * 59 + ($basePath == null ? 43 : $basePath.hashCode());
            return result;
        }

        public String toString() {
            return "FileStorageProperties.QiniuKodo(accessKey=" + this.getAccessKey() + ", secretKey=" + this.getSecretKey() + ", bucketName=" + this.getBucketName() + ", domain=" + this.getDomain() + ", enableStorage=" + this.getEnableStorage() + ", platform=" + this.getPlatform() + ", basePath=" + this.getBasePath() + ")";
        }
    }

    public static class AliyunOss {
        private String accessKey;
        private String secretKey;
        private String endPoint;
        private String bucketName;
        private String domain = "";
        private Boolean enableStorage = false;
        private String platform = "";
        private String basePath = "";

        public String getAccessKey() {
            return this.accessKey;
        }

        public String getSecretKey() {
            return this.secretKey;
        }

        public String getEndPoint() {
            return this.endPoint;
        }

        public String getBucketName() {
            return this.bucketName;
        }

        public String getDomain() {
            return this.domain;
        }

        public Boolean getEnableStorage() {
            return this.enableStorage;
        }

        public String getPlatform() {
            return this.platform;
        }

        public String getBasePath() {
            return this.basePath;
        }

        public void setAccessKey(String accessKey) {
            this.accessKey = accessKey;
        }

        public void setSecretKey(String secretKey) {
            this.secretKey = secretKey;
        }

        public void setEndPoint(String endPoint) {
            this.endPoint = endPoint;
        }

        public void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        public void setDomain(String domain) {
            this.domain = domain;
        }

        public void setEnableStorage(Boolean enableStorage) {
            this.enableStorage = enableStorage;
        }

        public void setPlatform(String platform) {
            this.platform = platform;
        }

        public void setBasePath(String basePath) {
            this.basePath = basePath;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AliyunOss)) {
                return false;
            }
            AliyunOss other = (AliyunOss)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$enableStorage = this.getEnableStorage();
            Boolean other$enableStorage = other.getEnableStorage();
            if (this$enableStorage == null ? other$enableStorage != null : !((Object)this$enableStorage).equals(other$enableStorage)) {
                return false;
            }
            String this$accessKey = this.getAccessKey();
            String other$accessKey = other.getAccessKey();
            if (this$accessKey == null ? other$accessKey != null : !this$accessKey.equals(other$accessKey)) {
                return false;
            }
            String this$secretKey = this.getSecretKey();
            String other$secretKey = other.getSecretKey();
            if (this$secretKey == null ? other$secretKey != null : !this$secretKey.equals(other$secretKey)) {
                return false;
            }
            String this$endPoint = this.getEndPoint();
            String other$endPoint = other.getEndPoint();
            if (this$endPoint == null ? other$endPoint != null : !this$endPoint.equals(other$endPoint)) {
                return false;
            }
            String this$bucketName = this.getBucketName();
            String other$bucketName = other.getBucketName();
            if (this$bucketName == null ? other$bucketName != null : !this$bucketName.equals(other$bucketName)) {
                return false;
            }
            String this$domain = this.getDomain();
            String other$domain = other.getDomain();
            if (this$domain == null ? other$domain != null : !this$domain.equals(other$domain)) {
                return false;
            }
            String this$platform = this.getPlatform();
            String other$platform = other.getPlatform();
            if (this$platform == null ? other$platform != null : !this$platform.equals(other$platform)) {
                return false;
            }
            String this$basePath = this.getBasePath();
            String other$basePath = other.getBasePath();
            return !(this$basePath == null ? other$basePath != null : !this$basePath.equals(other$basePath));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AliyunOss;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $enableStorage = this.getEnableStorage();
            result = result * 59 + ($enableStorage == null ? 43 : ((Object)$enableStorage).hashCode());
            String $accessKey = this.getAccessKey();
            result = result * 59 + ($accessKey == null ? 43 : $accessKey.hashCode());
            String $secretKey = this.getSecretKey();
            result = result * 59 + ($secretKey == null ? 43 : $secretKey.hashCode());
            String $endPoint = this.getEndPoint();
            result = result * 59 + ($endPoint == null ? 43 : $endPoint.hashCode());
            String $bucketName = this.getBucketName();
            result = result * 59 + ($bucketName == null ? 43 : $bucketName.hashCode());
            String $domain = this.getDomain();
            result = result * 59 + ($domain == null ? 43 : $domain.hashCode());
            String $platform = this.getPlatform();
            result = result * 59 + ($platform == null ? 43 : $platform.hashCode());
            String $basePath = this.getBasePath();
            result = result * 59 + ($basePath == null ? 43 : $basePath.hashCode());
            return result;
        }

        public String toString() {
            return "FileStorageProperties.AliyunOss(accessKey=" + this.getAccessKey() + ", secretKey=" + this.getSecretKey() + ", endPoint=" + this.getEndPoint() + ", bucketName=" + this.getBucketName() + ", domain=" + this.getDomain() + ", enableStorage=" + this.getEnableStorage() + ", platform=" + this.getPlatform() + ", basePath=" + this.getBasePath() + ")";
        }
    }

    public static class HuaweiObs {
        private String accessKey;
        private String secretKey;
        private String endPoint;
        private String bucketName;
        private String domain = "";
        private Boolean enableStorage = false;
        private String platform = "";
        private String basePath = "";

        public String getAccessKey() {
            return this.accessKey;
        }

        public String getSecretKey() {
            return this.secretKey;
        }

        public String getEndPoint() {
            return this.endPoint;
        }

        public String getBucketName() {
            return this.bucketName;
        }

        public String getDomain() {
            return this.domain;
        }

        public Boolean getEnableStorage() {
            return this.enableStorage;
        }

        public String getPlatform() {
            return this.platform;
        }

        public String getBasePath() {
            return this.basePath;
        }

        public void setAccessKey(String accessKey) {
            this.accessKey = accessKey;
        }

        public void setSecretKey(String secretKey) {
            this.secretKey = secretKey;
        }

        public void setEndPoint(String endPoint) {
            this.endPoint = endPoint;
        }

        public void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        public void setDomain(String domain) {
            this.domain = domain;
        }

        public void setEnableStorage(Boolean enableStorage) {
            this.enableStorage = enableStorage;
        }

        public void setPlatform(String platform) {
            this.platform = platform;
        }

        public void setBasePath(String basePath) {
            this.basePath = basePath;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof HuaweiObs)) {
                return false;
            }
            HuaweiObs other = (HuaweiObs)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$enableStorage = this.getEnableStorage();
            Boolean other$enableStorage = other.getEnableStorage();
            if (this$enableStorage == null ? other$enableStorage != null : !((Object)this$enableStorage).equals(other$enableStorage)) {
                return false;
            }
            String this$accessKey = this.getAccessKey();
            String other$accessKey = other.getAccessKey();
            if (this$accessKey == null ? other$accessKey != null : !this$accessKey.equals(other$accessKey)) {
                return false;
            }
            String this$secretKey = this.getSecretKey();
            String other$secretKey = other.getSecretKey();
            if (this$secretKey == null ? other$secretKey != null : !this$secretKey.equals(other$secretKey)) {
                return false;
            }
            String this$endPoint = this.getEndPoint();
            String other$endPoint = other.getEndPoint();
            if (this$endPoint == null ? other$endPoint != null : !this$endPoint.equals(other$endPoint)) {
                return false;
            }
            String this$bucketName = this.getBucketName();
            String other$bucketName = other.getBucketName();
            if (this$bucketName == null ? other$bucketName != null : !this$bucketName.equals(other$bucketName)) {
                return false;
            }
            String this$domain = this.getDomain();
            String other$domain = other.getDomain();
            if (this$domain == null ? other$domain != null : !this$domain.equals(other$domain)) {
                return false;
            }
            String this$platform = this.getPlatform();
            String other$platform = other.getPlatform();
            if (this$platform == null ? other$platform != null : !this$platform.equals(other$platform)) {
                return false;
            }
            String this$basePath = this.getBasePath();
            String other$basePath = other.getBasePath();
            return !(this$basePath == null ? other$basePath != null : !this$basePath.equals(other$basePath));
        }

        protected boolean canEqual(Object other) {
            return other instanceof HuaweiObs;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $enableStorage = this.getEnableStorage();
            result = result * 59 + ($enableStorage == null ? 43 : ((Object)$enableStorage).hashCode());
            String $accessKey = this.getAccessKey();
            result = result * 59 + ($accessKey == null ? 43 : $accessKey.hashCode());
            String $secretKey = this.getSecretKey();
            result = result * 59 + ($secretKey == null ? 43 : $secretKey.hashCode());
            String $endPoint = this.getEndPoint();
            result = result * 59 + ($endPoint == null ? 43 : $endPoint.hashCode());
            String $bucketName = this.getBucketName();
            result = result * 59 + ($bucketName == null ? 43 : $bucketName.hashCode());
            String $domain = this.getDomain();
            result = result * 59 + ($domain == null ? 43 : $domain.hashCode());
            String $platform = this.getPlatform();
            result = result * 59 + ($platform == null ? 43 : $platform.hashCode());
            String $basePath = this.getBasePath();
            result = result * 59 + ($basePath == null ? 43 : $basePath.hashCode());
            return result;
        }

        public String toString() {
            return "FileStorageProperties.HuaweiObs(accessKey=" + this.getAccessKey() + ", secretKey=" + this.getSecretKey() + ", endPoint=" + this.getEndPoint() + ", bucketName=" + this.getBucketName() + ", domain=" + this.getDomain() + ", enableStorage=" + this.getEnableStorage() + ", platform=" + this.getPlatform() + ", basePath=" + this.getBasePath() + ")";
        }
    }

    public static class LocalPlus {
        private String basePath = "";
        private String storagePath = "/";
        private String[] pathPatterns = new String[0];
        private Boolean enableStorage = false;
        private Boolean enableAccess = false;
        private String platform = "local";
        private String domain = "";

        public String getBasePath() {
            return this.basePath;
        }

        public String getStoragePath() {
            return this.storagePath;
        }

        public String[] getPathPatterns() {
            return this.pathPatterns;
        }

        public Boolean getEnableStorage() {
            return this.enableStorage;
        }

        public Boolean getEnableAccess() {
            return this.enableAccess;
        }

        public String getPlatform() {
            return this.platform;
        }

        public String getDomain() {
            return this.domain;
        }

        public void setBasePath(String basePath) {
            this.basePath = basePath;
        }

        public void setStoragePath(String storagePath) {
            this.storagePath = storagePath;
        }

        public void setPathPatterns(String[] pathPatterns) {
            this.pathPatterns = pathPatterns;
        }

        public void setEnableStorage(Boolean enableStorage) {
            this.enableStorage = enableStorage;
        }

        public void setEnableAccess(Boolean enableAccess) {
            this.enableAccess = enableAccess;
        }

        public void setPlatform(String platform) {
            this.platform = platform;
        }

        public void setDomain(String domain) {
            this.domain = domain;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LocalPlus)) {
                return false;
            }
            LocalPlus other = (LocalPlus)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$enableStorage = this.getEnableStorage();
            Boolean other$enableStorage = other.getEnableStorage();
            if (this$enableStorage == null ? other$enableStorage != null : !((Object)this$enableStorage).equals(other$enableStorage)) {
                return false;
            }
            Boolean this$enableAccess = this.getEnableAccess();
            Boolean other$enableAccess = other.getEnableAccess();
            if (this$enableAccess == null ? other$enableAccess != null : !((Object)this$enableAccess).equals(other$enableAccess)) {
                return false;
            }
            String this$basePath = this.getBasePath();
            String other$basePath = other.getBasePath();
            if (this$basePath == null ? other$basePath != null : !this$basePath.equals(other$basePath)) {
                return false;
            }
            String this$storagePath = this.getStoragePath();
            String other$storagePath = other.getStoragePath();
            if (this$storagePath == null ? other$storagePath != null : !this$storagePath.equals(other$storagePath)) {
                return false;
            }
            if (!Arrays.deepEquals(this.getPathPatterns(), other.getPathPatterns())) {
                return false;
            }
            String this$platform = this.getPlatform();
            String other$platform = other.getPlatform();
            if (this$platform == null ? other$platform != null : !this$platform.equals(other$platform)) {
                return false;
            }
            String this$domain = this.getDomain();
            String other$domain = other.getDomain();
            return !(this$domain == null ? other$domain != null : !this$domain.equals(other$domain));
        }

        protected boolean canEqual(Object other) {
            return other instanceof LocalPlus;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $enableStorage = this.getEnableStorage();
            result = result * 59 + ($enableStorage == null ? 43 : ((Object)$enableStorage).hashCode());
            Boolean $enableAccess = this.getEnableAccess();
            result = result * 59 + ($enableAccess == null ? 43 : ((Object)$enableAccess).hashCode());
            String $basePath = this.getBasePath();
            result = result * 59 + ($basePath == null ? 43 : $basePath.hashCode());
            String $storagePath = this.getStoragePath();
            result = result * 59 + ($storagePath == null ? 43 : $storagePath.hashCode());
            result = result * 59 + Arrays.deepHashCode(this.getPathPatterns());
            String $platform = this.getPlatform();
            result = result * 59 + ($platform == null ? 43 : $platform.hashCode());
            String $domain = this.getDomain();
            result = result * 59 + ($domain == null ? 43 : $domain.hashCode());
            return result;
        }

        public String toString() {
            return "FileStorageProperties.LocalPlus(basePath=" + this.getBasePath() + ", storagePath=" + this.getStoragePath() + ", pathPatterns=" + Arrays.deepToString(this.getPathPatterns()) + ", enableStorage=" + this.getEnableStorage() + ", enableAccess=" + this.getEnableAccess() + ", platform=" + this.getPlatform() + ", domain=" + this.getDomain() + ")";
        }
    }

    public static class Local {
        private String basePath = "";
        private String[] pathPatterns = new String[0];
        private Boolean enableStorage = false;
        private Boolean enableAccess = false;
        private String platform = "local";
        private String domain = "";

        public String getBasePath() {
            return this.basePath;
        }

        public String[] getPathPatterns() {
            return this.pathPatterns;
        }

        public Boolean getEnableStorage() {
            return this.enableStorage;
        }

        public Boolean getEnableAccess() {
            return this.enableAccess;
        }

        public String getPlatform() {
            return this.platform;
        }

        public String getDomain() {
            return this.domain;
        }

        public void setBasePath(String basePath) {
            this.basePath = basePath;
        }

        public void setPathPatterns(String[] pathPatterns) {
            this.pathPatterns = pathPatterns;
        }

        public void setEnableStorage(Boolean enableStorage) {
            this.enableStorage = enableStorage;
        }

        public void setEnableAccess(Boolean enableAccess) {
            this.enableAccess = enableAccess;
        }

        public void setPlatform(String platform) {
            this.platform = platform;
        }

        public void setDomain(String domain) {
            this.domain = domain;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Local)) {
                return false;
            }
            Local other = (Local)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$enableStorage = this.getEnableStorage();
            Boolean other$enableStorage = other.getEnableStorage();
            if (this$enableStorage == null ? other$enableStorage != null : !((Object)this$enableStorage).equals(other$enableStorage)) {
                return false;
            }
            Boolean this$enableAccess = this.getEnableAccess();
            Boolean other$enableAccess = other.getEnableAccess();
            if (this$enableAccess == null ? other$enableAccess != null : !((Object)this$enableAccess).equals(other$enableAccess)) {
                return false;
            }
            String this$basePath = this.getBasePath();
            String other$basePath = other.getBasePath();
            if (this$basePath == null ? other$basePath != null : !this$basePath.equals(other$basePath)) {
                return false;
            }
            if (!Arrays.deepEquals(this.getPathPatterns(), other.getPathPatterns())) {
                return false;
            }
            String this$platform = this.getPlatform();
            String other$platform = other.getPlatform();
            if (this$platform == null ? other$platform != null : !this$platform.equals(other$platform)) {
                return false;
            }
            String this$domain = this.getDomain();
            String other$domain = other.getDomain();
            return !(this$domain == null ? other$domain != null : !this$domain.equals(other$domain));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Local;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $enableStorage = this.getEnableStorage();
            result = result * 59 + ($enableStorage == null ? 43 : ((Object)$enableStorage).hashCode());
            Boolean $enableAccess = this.getEnableAccess();
            result = result * 59 + ($enableAccess == null ? 43 : ((Object)$enableAccess).hashCode());
            String $basePath = this.getBasePath();
            result = result * 59 + ($basePath == null ? 43 : $basePath.hashCode());
            result = result * 59 + Arrays.deepHashCode(this.getPathPatterns());
            String $platform = this.getPlatform();
            result = result * 59 + ($platform == null ? 43 : $platform.hashCode());
            String $domain = this.getDomain();
            result = result * 59 + ($domain == null ? 43 : $domain.hashCode());
            return result;
        }

        public String toString() {
            return "FileStorageProperties.Local(basePath=" + this.getBasePath() + ", pathPatterns=" + Arrays.deepToString(this.getPathPatterns()) + ", enableStorage=" + this.getEnableStorage() + ", enableAccess=" + this.getEnableAccess() + ", platform=" + this.getPlatform() + ", domain=" + this.getDomain() + ")";
        }
    }
}

