/*
 * Decompiled with CFR 0.152.
 */
package cn.xuyanwu.spring.file.storage.platform;

import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import cn.xuyanwu.spring.file.storage.FileInfo;
import cn.xuyanwu.spring.file.storage.UploadPretreatment;
import cn.xuyanwu.spring.file.storage.exception.FileStorageRuntimeException;
import cn.xuyanwu.spring.file.storage.platform.FileStorage;
import com.google.auth.Credentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.cloud.ReadChannel;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageOptions;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;

public class GoogleCloudStorage
implements FileStorage {
    private String projectId;
    private String bucketName;
    private String credentialsPath;
    private String basePath;
    private String platform;
    private String domain;
    private Storage client;

    public Storage getClient() {
        if (this.client == null) {
            ServiceAccountCredentials credentialsFromStream;
            try (InputStream in = URLUtil.url((String)this.credentialsPath).openStream();){
                credentialsFromStream = ServiceAccountCredentials.fromStream((InputStream)in);
            }
            catch (IOException e) {
                throw new FileStorageRuntimeException("Google Cloud Platform \u6388\u6743 key \u6587\u4ef6\u83b7\u53d6\u5931\u8d25\uff01credentialsPath\uff1a" + this.credentialsPath);
            }
            List<String> scopes = Collections.singletonList("https://www.googleapis.com/auth/cloud-platform");
            ServiceAccountCredentials credentials = credentialsFromStream.toBuilder().setScopes(scopes).build();
            StorageOptions storageOptions = ((StorageOptions.Builder)((StorageOptions.Builder)StorageOptions.newBuilder().setProjectId(this.projectId)).setCredentials((Credentials)credentials)).build();
            this.client = (Storage)storageOptions.getService();
        }
        return this.client;
    }

    @Override
    public void close() {
        if (this.client != null) {
            try {
                this.client.close();
            }
            catch (Exception e) {
                throw new FileStorageRuntimeException(e);
            }
            this.client = null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean save(FileInfo fileInfo, UploadPretreatment pre) {
        String newFileKey = this.basePath + fileInfo.getPath() + fileInfo.getFilename();
        fileInfo.setBasePath(this.basePath);
        fileInfo.setUrl(this.domain + newFileKey);
        Storage client = this.getClient();
        BlobId blobId = BlobId.of((String)this.bucketName, (String)newFileKey);
        BlobInfo blobInfo = BlobInfo.newBuilder((BlobId)blobId).setContentType(fileInfo.getContentType()).build();
        try (InputStream in = pre.getFileWrapper().getInputStream();){
            client.createFrom(blobInfo, in, new Storage.BlobWriteOption[0]);
            byte[] thumbnailBytes = pre.getThumbnailBytes();
            if (thumbnailBytes != null) {
                String newThFileKey = this.basePath + fileInfo.getPath() + fileInfo.getThFilename();
                fileInfo.setThUrl(this.domain + newThFileKey);
                BlobId thBlobId = BlobId.of((String)this.bucketName, (String)newThFileKey);
                BlobInfo thBlobInfo = BlobInfo.newBuilder((BlobId)thBlobId).setContentType(fileInfo.getThContentType()).build();
                client.createFrom(thBlobInfo, (InputStream)new ByteArrayInputStream(thumbnailBytes), new Storage.BlobWriteOption[0]);
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            this.checkAndDelete(newFileKey);
            throw new FileStorageRuntimeException("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff01platform\uff1a" + this.platform + "\uff0cfilename\uff1a" + fileInfo.getOriginalFilename(), e);
        }
    }

    private void checkAndDelete(String fileKey) {
        Storage client = this.getClient();
        Blob blob = client.get(this.bucketName, fileKey, new Storage.BlobGetOption[0]);
        if (blob != null) {
            Storage.BlobSourceOption precondition = Storage.BlobSourceOption.generationMatch((long)blob.getGeneration());
            client.delete(this.bucketName, fileKey, new Storage.BlobSourceOption[]{precondition});
        }
    }

    @Override
    public boolean delete(FileInfo fileInfo) {
        if (fileInfo.getThFilename() != null) {
            this.checkAndDelete(fileInfo.getBasePath() + fileInfo.getPath() + fileInfo.getThFilename());
        }
        this.checkAndDelete(fileInfo.getBasePath() + fileInfo.getPath() + fileInfo.getFilename());
        return true;
    }

    @Override
    public boolean exists(FileInfo fileInfo) {
        BlobId blobId;
        Storage client = this.getClient();
        return client.get(blobId = BlobId.of((String)this.bucketName, (String)(fileInfo.getBasePath() + fileInfo.getPath() + fileInfo.getFilename()))) != null;
    }

    @Override
    public void download(FileInfo fileInfo, Consumer<InputStream> consumer) {
        Storage client = this.getClient();
        BlobId blobId = BlobId.of((String)this.bucketName, (String)(fileInfo.getBasePath() + fileInfo.getPath() + fileInfo.getFilename()));
        ReadChannel readChannel = client.reader(blobId, new Storage.BlobSourceOption[0]);
        InputStream in = Channels.newInputStream((ReadableByteChannel)readChannel);
        consumer.accept(in);
    }

    @Override
    public void downloadTh(FileInfo fileInfo, Consumer<InputStream> consumer) {
        if (StrUtil.isBlank((CharSequence)fileInfo.getThFilename())) {
            throw new FileStorageRuntimeException("\u7f29\u7565\u56fe\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff0c\u6587\u4ef6\u4e0d\u5b58\u5728\uff01fileInfo\uff1a" + fileInfo);
        }
        Storage client = this.getClient();
        BlobId thBlobId = BlobId.of((String)this.bucketName, (String)(fileInfo.getBasePath() + fileInfo.getPath() + fileInfo.getThFilename()));
        ReadChannel readChannel = client.reader(thBlobId, new Storage.BlobSourceOption[0]);
        InputStream in = Channels.newInputStream((ReadableByteChannel)readChannel);
        consumer.accept(in);
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getCredentialsPath() {
        return this.credentialsPath;
    }

    public String getBasePath() {
        return this.basePath;
    }

    @Override
    public String getPlatform() {
        return this.platform;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public void setCredentialsPath(String credentialsPath) {
        this.credentialsPath = credentialsPath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    @Override
    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public void setClient(Storage client) {
        this.client = client;
    }
}

