package cn.zcltd.btg.lab.timeout;

import java.sql.*;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.*;

/**
 * 超时
 */
public class TimeOut {
    public static void main(String[] args) throws Exception {
        final ExecutorService exec = Executors.newFixedThreadPool(1);

        Callable<Boolean> call = new Callable<Boolean>() {
            public Boolean call() throws Exception {
                try {
                    String jdbcDriver = "com.mysql.jdbc.Driver";
                    String jdbcUrl = "jdbc:mysql://192.168.0.222:3306/test?characterEncoding=utf8&zeroDateTimeBehavior=convertToNull";
                    String jdbcUsername = "root";
                    String jdbcPassword = "admin123";
                    String jdbcTestSql = "SELECT 1";

                    Class.forName(jdbcDriver);

                    Connection conn = DriverManager.getConnection(jdbcUrl, jdbcUsername, jdbcPassword);
                    Statement stmt = conn.createStatement();
                    ResultSet rs = stmt.executeQuery(jdbcTestSql);
                    ResultSetMetaData md = rs.getMetaData();
                    int columnCount = md.getColumnCount();
                    while (rs.next()) {
                        Map<String, Object> rowData = new HashMap<String, Object>();
                        for (int i = 1; i <= columnCount; i++) {
                            rowData.put(md.getColumnName(i), rs.getObject(i));
                        }
                        System.out.println(rowData);
                    }
                    rs.close();
                    stmt.close();
                    conn.close();
                } catch (Exception e) {
                    e.printStackTrace();
                    return false;
                }

                return true;
            }
        };

        try {
            Future<Boolean> future = exec.submit(call);
            Boolean obj = future.get(1000 * 3, TimeUnit.MILLISECONDS);
            System.out.println("处理结果:" + obj);
        } catch (TimeoutException e) {
            System.out.println("处理超时");
        }

        // 关闭线程池
        exec.shutdown();
    }
}