/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.data;

import cn.zhxu.data.DataSet;
import cn.zhxu.data.Mapper;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Spliterators;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public interface Array
extends DataSet,
Iterable<DataSet.Data> {
    public Mapper getMapper(int var1);

    public Array getArray(int var1);

    public boolean getBool(int var1);

    public int getInt(int var1);

    public long getLong(int var1);

    public float getFloat(int var1);

    public double getDouble(int var1);

    public String getString(int var1);

    default public Stream<DataSet.Data> stream() {
        return StreamSupport.stream(Spliterators.spliterator(this.iterator(), (long)this.size(), 0), false);
    }

    @Override
    default public Iterator<DataSet.Data> iterator() {
        return new Itr(this);
    }

    default public void forEach(BiConsumer<Integer, DataSet.Data> consumer) {
        for (int i = 0; i < this.size(); ++i) {
            consumer.accept(i, new IdxData(this, i));
        }
    }

    public <T> List<T> toList(Class<T> var1);

    public List<Object> toList();

    default public int[] toIntArray() {
        int[] array = new int[this.size()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.getInt(i);
        }
        return array;
    }

    default public long[] toLongArray() {
        long[] array = new long[this.size()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.getLong(i);
        }
        return array;
    }

    default public float[] toFloatArray() {
        float[] array = new float[this.size()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.getFloat(i);
        }
        return array;
    }

    default public double[] toDoubleArray() {
        double[] array = new double[this.size()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.getDouble(i);
        }
        return array;
    }

    public static class IdxData
    implements DataSet.Data {
        private final Array array;
        private final int index;

        public IdxData(Array array, int index) {
            this.array = array;
            this.index = index;
        }

        @Override
        public Mapper toMapper() {
            return this.array.getMapper(this.index);
        }

        @Override
        public Array toArray() {
            return this.array.getArray(this.index);
        }

        @Override
        public boolean toBool() {
            return this.array.getBool(this.index);
        }

        @Override
        public int toInt() {
            return this.array.getInt(this.index);
        }

        @Override
        public long toLong() {
            return this.array.getLong(this.index);
        }

        @Override
        public float toFloat() {
            return this.array.getFloat(this.index);
        }

        @Override
        public double toDouble() {
            return this.array.getDouble(this.index);
        }

        @Override
        public String toString() {
            return this.array.getString(this.index);
        }
    }

    public static class Itr
    implements Iterator<DataSet.Data> {
        Array array;
        int cursor = 0;

        Itr(Array array) {
            this.array = array;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < this.array.size();
        }

        @Override
        public DataSet.Data next() {
            int i = this.cursor;
            if (i >= this.array.size()) {
                throw new NoSuchElementException();
            }
            return new IdxData(this.array, this.cursor++);
        }
    }
}

